/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.service.impl;

import com.alibaba.fastjson.JSON;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.service.AmazonS3UploadService;
import com.biz.crm.util.AmazonS3Config;
import com.biz.crm.util.DateUtil;
import com.biz.crm.vo.DownLoadVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class AmazonS3UploadServiceImpl
implements AmazonS3UploadService {
    private static final Logger log = LoggerFactory.getLogger(AmazonS3UploadServiceImpl.class);
    @Resource
    private AmazonS3 s3client;
    @Resource
    private AmazonS3Config amazonS3Config;

    @Override
    public String getType() {
        return "amazons3";
    }

    @Override
    public List<UploadVo> upload(MultipartFile[] fileList) {
        ArrayList<UploadVo> uploadVos = new ArrayList<UploadVo>();
        MultipartFile[] var3 = fileList;
        int var4 = fileList.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            MultipartFile file = var3[var5];
            String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            try {
                String objectName = uuid + "." + suffix.toLowerCase();
                objectName = StringUtils.isNotBlank((CharSequence)suffix) ? suffix + "/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName : "default/" + DateUtil.date2Str((SimpleDateFormat)new SimpleDateFormat("yyyyMMdd")) + "/" + objectName;
                ObjectMetadata objectMetadata = new ObjectMetadata();
                objectMetadata.setContentType(file.getContentType());
                objectMetadata.setContentLength(file.getSize());
                this.s3client.putObject(new PutObjectRequest(this.amazonS3Config.bucketName, objectName, file.getInputStream(), objectMetadata).withCannedAcl(CannedAccessControlList.PublicRead));
                if (log.isDebugEnabled()) {
                    GeneratePresignedUrlRequest urlRequest = new GeneratePresignedUrlRequest(this.amazonS3Config.bucketName, objectName);
                    URL url = this.s3client.generatePresignedUrl(urlRequest);
                    log.debug("Upload URL : {}", (Object)JSON.toJSONString((Object)url));
                }
                String urlPathPrefix = this.amazonS3Config.endpoint.concat("/").concat(this.amazonS3Config.bucketName).concat("/");
                UploadVo temp = new UploadVo();
                temp.setUrl(urlPathPrefix.concat(objectName));
                temp.setSuffix(suffix);
                temp.setFileName(file.getOriginalFilename());
                temp.setUrlPathPrefix(urlPathPrefix);
                temp.setUrlPath(objectName);
                temp.setObjectName(objectName);
                uploadVos.add(temp);
                continue;
            }
            catch (AmazonClientException | IOException var12) {
                log.error("", var12);
                throw new BusinessException("\u4e0a\u4f20\u5931\u8d25");
            }
        }
        return uploadVos;
    }

    private String upload(InputStream input, String key) throws IOException {
        Date expireDate = new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(30L));
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setHttpExpiresDate(expireDate);
        metadata.setContentLength((long)input.available());
        this.s3client.putObject(new PutObjectRequest(this.amazonS3Config.bucketName, key, input, metadata).withCannedAcl(CannedAccessControlList.PublicRead));
        GeneratePresignedUrlRequest urlRequest = new GeneratePresignedUrlRequest(this.amazonS3Config.bucketName, key);
        URL url = this.s3client.generatePresignedUrl(urlRequest);
        return url.toString();
    }

    @Override
    public DownLoadVo download(String objectName) {
        if (!StringUtils.isEmpty((CharSequence)objectName)) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile(objectName, null);
                String path = this.amazonS3Config.endpoint.concat("/").concat(this.amazonS3Config.bucketName).concat("/").concat(objectName);
                TransferManager transferManager = new TransferManager(this.s3client);
                Download download = transferManager.download(this.amazonS3Config.bucketName, objectName, tmpFile);
                download.waitForCompletion();
                DownLoadVo downLoadVo = new DownLoadVo(objectName, new FileInputStream(tmpFile), path, String.valueOf(download.getObjectMetadata().getContentLength()));
                return downLoadVo;
            }
            catch (IOException | InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
            }
            finally {
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.deleteOnExit();
                }
            }
        }
        return null;
    }
}

