/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.config.service.CommonWebserviceService;
import com.biz.crm.config.service.DoBusiness;
import com.biz.crm.config.service.WebserviceLogService;
import com.biz.crm.entity.WebserviceLogEntity;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.WebserveCallHead;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@WebService
public class CommonWebserviceServiceImpl
implements CommonWebserviceService {
    private static final Logger log = LoggerFactory.getLogger(CommonWebserviceServiceImpl.class);
    @Autowired
    private RedisService redisService;
    @Autowired
    private WebserviceLogService webserviceLogService;
    @Resource
    private WebServiceContext webServiceContext;
    private static Map<String, DoBusiness> businessMap = new HashMap<String, DoBusiness>();
    @Value(value="${webservices.token:123456}")
    private String webserviceToken;
    @Value(value="${webservices.username:admin}")
    private String username;

    private WebserveCallHead check(WebserveCallHead webserveCallHead) {
        String status = "E";
        if (StringUtils.isEmpty((String)webserveCallHead.getToken()) || StringUtils.isEmpty((String)webserveCallHead.getMethod()) || StringUtils.isEmpty((String)webserveCallHead.getUuid())) {
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("\u53c2\u6570\u4f20\u5165\u4e0d\u5168");
            return webserveCallHead;
        }
        if (!this.webserviceToken.equals(webserveCallHead.getToken())) {
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("\u6ca1\u6709\u8ba4\u8bc1\u6743\u9650");
            return webserveCallHead;
        }
        if (!businessMap.containsKey(webserveCallHead.getMethod())) {
            ApplicationContext applicationContext = SpringApplicationContextUtil.getApplicationContext();
            if (!applicationContext.containsBean(webserveCallHead.getMethod())) {
                webserveCallHead.setStatus(status);
                webserveCallHead.setMsg(webserveCallHead.getMethod() + "\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528");
                return webserveCallHead;
            }
            Object object = applicationContext.getBean(webserveCallHead.getMethod());
            if (object == null) {
                webserveCallHead.setStatus(status);
                webserveCallHead.setMsg(webserveCallHead.getMethod() + "\u65b9\u6cd5\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528");
                return webserveCallHead;
            }
            DoBusiness doBusiness = (DoBusiness)object;
            businessMap.put(webserveCallHead.getMethod(), doBusiness);
        }
        return webserveCallHead;
    }

    private WebserviceLogEntity resovleAndSaveLogEntity(String json) {
        WebserviceLogEntity entity = new WebserviceLogEntity();
        if (StringUtils.isEmpty((String)json)) {
            json = "JSON\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
        }
        entity.setReqJson(json);
        entity.setReqDate(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").format(LocalDateTime.now()));
        this.webserviceLogService.updateSaveLog(entity);
        return entity;
    }

    @Override
    public String crmWebservice(String json) {
        log.info("webservice\u4f20\u5165\u503c:" + json);
        WebserviceLogEntity logEntity = this.resovleAndSaveLogEntity(json);
        WebserveCallHead webserveCallHead = new WebserveCallHead();
        if (StringUtils.isEmpty((String)json)) {
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("\u53c2\u6570\u9519\u8bef");
            logEntity.setMsg(webserveCallHead.getMsg());
            logEntity.setStatus(webserveCallHead.getStatus());
            logEntity.setRespDate(logEntity.getReqDate());
            String resp = JSONObject.toJSONString((Object)webserveCallHead);
            logEntity.setRespJson(resp);
            this.webserviceLogService.updateSaveLog(logEntity);
            return resp;
        }
        try {
            webserveCallHead = (WebserveCallHead)JsonPropertyUtil.toObject((String)json, WebserveCallHead.class);
            if (null != webserveCallHead && StringUtils.isEmpty((String)webserveCallHead.getToken())) {
                String token = this.getTokenFromSoapHead();
                webserveCallHead.setToken(token);
            }
            if (StringUtils.isEmpty((String)webserveCallHead.getToken())) {
                JSONObject object = JSONObject.parseObject((String)json);
                String token = object.get((Object)"TOKEN") == null ? "" : object.get((Object)"TOKEN").toString();
                webserveCallHead.setToken(token);
                String method = object.get((Object)"METHOD") == null ? "" : object.get((Object)"METHOD").toString();
                webserveCallHead.setMethod(method);
                String uuid = object.get((Object)"UUID") == null ? "" : object.get((Object)"UUID").toString();
                webserveCallHead.setUuid(uuid);
                String text = object.get((Object)"TEXT") == null ? "" : object.get((Object)"TEXT").toString();
                webserveCallHead.setText(text);
            }
            webserveCallHead.setStatus("S");
            this.check(webserveCallHead);
            if ("S".equals(webserveCallHead.getStatus())) {
                UserUtils.doTokenForNull();
                webserveCallHead = businessMap.get(webserveCallHead.getMethod()).execute(webserveCallHead, json);
                if (webserveCallHead == null) {
                    webserveCallHead = (WebserveCallHead)JsonPropertyUtil.toObject((String)json, WebserveCallHead.class);
                    webserveCallHead.setStatus("E");
                    webserveCallHead.setMsg("\u7cfb\u7edf\u5f02\u5e38");
                }
            }
        }
        catch (Exception e) {
            webserveCallHead = webserveCallHead == null ? new WebserveCallHead() : webserveCallHead;
            e.printStackTrace();
            logEntity.setExceptionStack(this.resolveExceptionStack(e));
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("\u7cfb\u7edf\u5f02\u5e38");
        }
        String jsonRetrun = JSONObject.toJSONString((Object)webserveCallHead);
        log.info("webservice\u8fd4\u56de\u503c:" + jsonRetrun);
        this.updateLogEntity(logEntity, webserveCallHead, jsonRetrun);
        return jsonRetrun;
    }

    private void updateLogEntity(WebserviceLogEntity logEntity, WebserveCallHead webserveCallHead, String jsonRetrun) {
        logEntity.setMethod(webserveCallHead.getMethod());
        logEntity.setToken(webserveCallHead.getToken());
        logEntity.setUuid(webserveCallHead.getUuid());
        logEntity.setMsg(webserveCallHead.getMsg());
        logEntity.setStatus(webserveCallHead.getStatus());
        logEntity.setRespDate(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").format(LocalDateTime.now()));
        logEntity.setRespJson(jsonRetrun);
        this.webserviceLogService.updateSaveLog(logEntity);
    }

    private String resolveExceptionStack(Exception e) {
        String expMessage;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(buf, true));
            expMessage = buf.toString();
            buf.close();
        }
        catch (IOException ex) {
            log.warn("\u5f02\u5e38\u5806\u6808\u89e3\u6790\u5931\u8d25:", (Object)e, (Object)ex);
            expMessage = "\u5f02\u5e38\u5806\u6808\u89e3\u6790\u5931\u8d25\u3002";
        }
        return expMessage;
    }

    public String getTokenFromSoapHead() {
        try {
            TreeMap headMap = (TreeMap)this.webServiceContext.getMessageContext().get((Object)Message.PROTOCOL_HEADERS);
            ArrayList token = (ArrayList)headMap.get("token");
            if (null == token) {
                token = (ArrayList)headMap.get("TOKEN");
            }
            return String.join((CharSequence)",", token);
        }
        catch (Exception e) {
            return null;
        }
    }
}

