package com.biz.crm.config.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.config.service.CommonWebserviceService;
import com.biz.crm.config.service.DoBusiness;
import com.biz.crm.config.service.WebserviceLogService;
import com.biz.crm.entity.WebserviceLogEntity;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.WebserveCallHead;
import lombok.extern.slf4j.Slf4j;
import org.apache.cxf.message.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author jianglong
 * @version V1.0
 * @Description: TODO
 * @date 2019/8/8 下午1:47
 */
@Component
@WebService
@Slf4j
public class CommonWebserviceServiceImpl implements CommonWebserviceService {
     @Autowired
     private RedisService redisService;
    @Autowired
     private WebserviceLogService webserviceLogService;

    @Resource
    private WebServiceContext webServiceContext;

    private static Map<String, DoBusiness> businessMap = new HashMap<>();
     @Value("${webservices.token:123456}")
     private String webserviceToken;
     @Value("${webservices.username:admin}")
     private String username;
     private WebserveCallHead check(WebserveCallHead webserveCallHead) {
        String status = "E";
        if (StringUtils.isEmpty(webserveCallHead.getToken()) ||
                StringUtils.isEmpty(webserveCallHead.getMethod()) ||
                StringUtils.isEmpty(webserveCallHead.getUuid()) ) {
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("参数传入不全");
            return webserveCallHead;
        }
        if(!webserviceToken.equals(webserveCallHead.getToken())){
            webserveCallHead.setStatus(status);
            webserveCallHead.setMsg("没有认证权限");
            return webserveCallHead;
        }
        if(!businessMap.containsKey(webserveCallHead.getMethod())){
            ApplicationContext applicationContext= SpringApplicationContextUtil.getApplicationContext();
            if(!applicationContext.containsBean(webserveCallHead.getMethod())){
                webserveCallHead.setStatus(status);
                webserveCallHead.setMsg(webserveCallHead.getMethod()+"方法不存在或者未启用");
                return webserveCallHead;
            }
           Object object = applicationContext.getBean(webserveCallHead.getMethod());
           if(object==null){
               webserveCallHead.setStatus(status);
               webserveCallHead.setMsg(webserveCallHead.getMethod()+"方法不存在或者未启用");
               return webserveCallHead;
           }
            DoBusiness doBusiness = (DoBusiness)object;
            businessMap.put(webserveCallHead.getMethod(),doBusiness);
        }
        return webserveCallHead;
    }

    private WebserviceLogEntity resovleAndSaveLogEntity(String json){
        WebserviceLogEntity entity = new WebserviceLogEntity();
//        entity.setMethod(webserveCallHead.getMethod());
//        entity.setMsg(webserveCallHead.getMsg());
//        entity.setStatus(webserveCallHead.getStatus());
//        entity.setToken(webserveCallHead.getToken());
//        entity.setUuid(webserveCallHead.getUuid());
        if(StringUtils.isEmpty(json))
        {
            json = "JSON请求参数为空";
        }
        entity.setReqJson(json);
        entity.setReqDate(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").format(LocalDateTime.now()));
        webserviceLogService.updateSaveLog(entity);
        return entity;
    }
    @Override
    public String crmWebservice(String json) {
        log.info("webservice传入值:" + json);
        WebserviceLogEntity logEntity = this.resovleAndSaveLogEntity(json);
        WebserveCallHead webserveCallHead = new WebserveCallHead();
        if(StringUtils.isEmpty(json)){
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("参数错误");
            logEntity.setMsg(webserveCallHead.getMsg());
            logEntity.setStatus(webserveCallHead.getStatus());
            logEntity.setRespDate(logEntity.getReqDate());
            String resp = JSONObject.toJSONString(webserveCallHead);
            logEntity.setRespJson(resp);
            webserviceLogService.updateSaveLog(logEntity);
            return resp;
        }
        try {
            webserveCallHead =  JsonPropertyUtil.toObject(json,WebserveCallHead.class);
            if (null != webserveCallHead && StringUtils.isEmpty(webserveCallHead.getToken())){
                //支持在请求头中传递token
                String token = getTokenFromSoapHead();
                webserveCallHead.setToken(token);
            }
            if(StringUtils.isEmpty(webserveCallHead.getToken())){
                JSONObject object = JSONObject.parseObject(json);
                String token = object.get("TOKEN")==null?"":object.get("TOKEN").toString();
                webserveCallHead.setToken(token);
                String method = object.get("METHOD")==null?"":object.get("METHOD").toString();
                webserveCallHead.setMethod(method);
                String uuid = object.get("UUID")==null?"":object.get("UUID").toString();
                webserveCallHead.setUuid(uuid);
                String text = object.get("TEXT")==null?"":object.get("TEXT").toString();
                webserveCallHead.setText(text);
            }
            webserveCallHead.setStatus("S");
            check(webserveCallHead);
            if ("S".equals(webserveCallHead.getStatus())) {
                UserUtils.doTokenForNull();
                webserveCallHead = businessMap.get(webserveCallHead.getMethod()).execute(webserveCallHead,json);
                if(webserveCallHead==null){
                    webserveCallHead =  JsonPropertyUtil.toObject(json,WebserveCallHead.class);
                    webserveCallHead.setStatus("E");
                    webserveCallHead.setMsg("系统异常");
                }
            }
        } catch (Exception e) {
            webserveCallHead = webserveCallHead==null?new WebserveCallHead():webserveCallHead;
            e.printStackTrace();
            logEntity.setExceptionStack(this.resolveExceptionStack(e));
            webserveCallHead.setStatus("E");
            webserveCallHead.setMsg("系统异常");
        }
        String jsonRetrun = JSONObject.toJSONString(webserveCallHead);
        log.info("webservice返回值:" + jsonRetrun);
        this.updateLogEntity(logEntity, webserveCallHead, jsonRetrun);
        return jsonRetrun;
    }
    private void updateLogEntity(WebserviceLogEntity logEntity, WebserveCallHead webserveCallHead, String jsonRetrun){
        logEntity.setMethod(webserveCallHead.getMethod());
        logEntity.setToken(webserveCallHead.getToken());
        logEntity.setUuid(webserveCallHead.getUuid());
        logEntity.setMsg(webserveCallHead.getMsg());
        logEntity.setStatus(webserveCallHead.getStatus());
        logEntity.setRespDate(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").format(LocalDateTime.now()));
        logEntity.setRespJson(jsonRetrun);
        webserviceLogService.updateSaveLog(logEntity);
    }
    private String resolveExceptionStack(Exception e){
        String expMessage;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            e.printStackTrace(new java.io.PrintWriter(buf, true));
            expMessage = buf.toString();
            buf.close();
        } catch (IOException ex) {
            log.error("异常堆栈解析失败:" ,e,ex);
            expMessage = "异常堆栈解析失败。";
        }
        return expMessage;
    }

    public String getTokenFromSoapHead(){
         try {
             TreeMap<String, ArrayList<String>> headMap = (TreeMap<String, ArrayList<String>>) webServiceContext.getMessageContext().get(Message.PROTOCOL_HEADERS);
             ArrayList<String> token = headMap.get("token");
             if (null == token){
                 token = headMap.get("TOKEN");
             }
             return String.join(",",token);
         }catch (Exception e){
            return null;
         }
    }

}
