package com.biz.crm.gaode.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.gaode.service.GaodeAroundService;
import com.biz.crm.gaode.util.GaodeUtil;
import com.biz.crm.gaode.vo.*;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.gaode.service.impl
 * @Description: TODO
 * @date 2021/3/8 下午1:08
 */
@Service
@Slf4j
public class GaodeAroundServiceImpl implements GaodeAroundService {
    @Value("${gaode.key:}")
    private String key;
    @Value("${gaode.radius:}")
    private String radius;
    @Value("${gaode.keywords:}")
    private String keywords;
    @Override
    public PageResult<GaodeNearbyVo> queryAround(QueryAroundVo queryAroundVo) {
        if (StringUtils.isNotEmpty(queryAroundVo.getRadius())){
            radius = queryAroundVo.getRadius();
        }
        if (StringUtils.isNotEmpty(queryAroundVo.getKeywords())){
            keywords = queryAroundVo.getKeywords();
        }

        if(StringUtils.isEmpty(key)
          ||StringUtils.isEmpty(radius)
                ||StringUtils.isEmpty(keywords)
        ){
            throw new BusinessException("请维护高德相关参数");
        }
        Map<String, String> uriVariables = new HashMap<>();
        StringBuffer url = new StringBuffer();
        url.append(GaodeUtil.aroundUrl).append("?key=").append(key);
        url.append("&").append("location=").append(queryAroundVo.getLocation());
        url.append("&").append("radius=").append(radius);
        url.append("&").append("keywords=").append(keywords);
        url.append("&").append("extensions=").append("all");
        url.append("&").append("offset=").append(queryAroundVo.getOffset());
        url.append("&").append("page=").append(queryAroundVo.getPage());
        log.info("请求高德附近门店url==> " + url.toString());
        ResponseEntity<String> resVoResponseEntity = RestTemplateUtils.getForEntity(url.toString(), String.class, uriVariables);
        String strRes = resVoResponseEntity.getBody();
        log.info("请求高德附近门店返回参数 ==> " + strRes);
        strRes = strRes.replaceAll("\"tel\":\\[]","\"tel\":\"\"");
        strRes = strRes.replaceAll("\"address\":\\[]","\"address\":\"\"");
        GaoResVo gaoResVo = JsonPropertyUtil.toObject(strRes,GaoResVo.class);
        PageResult<GaodeNearbyVo> pageResult = new PageResult<>();
        pageResult.setData(gaoResVo.getPois());
        pageResult.setCount(Long.parseLong(gaoResVo.getCount()));
        return  pageResult;
    }

    @Override
    public AmapPoiResultVo queryKeywords(AmapPoiQueryReqVo reqVo) {
        Map<String, String> uriVariables = new HashMap<>();
        StringBuffer url = new StringBuffer();
        url.append(GaodeUtil.keywordUrl).append("?key=").append(key);
        url.append("&").append("citylimit=").append(reqVo.getCitylimit());
        url.append("&").append("city=").append(reqVo.getCity());
        url.append("&").append("types=").append(reqVo.getTypes());
        url.append("&").append("extensions=").append("all");
        url.append("&").append("keywords=").append(reqVo.getKeywords());
        url.append("&").append("offset=").append(reqVo.getOffset());
        url.append("&").append("page=").append(reqVo.getPage());
        log.info("请求高德POI关键字查询url==> " + url.toString());
        ResponseEntity<String> resVoResponseEntity = RestTemplateUtils.getForEntity(url.toString(), String.class, uriVariables);
        String strRes = resVoResponseEntity.getBody();
        log.info("请求高德POI关键字查询返回参数 ==> " + strRes);
        strRes = strRes.replace("\"parent\":[]", "\"parent\":\"\"");
        strRes = strRes.replace("\"type\":[]", "\"type\":\"\"");
        strRes = strRes.replace("\"typecode\":[]", "\"typecode\":\"\"");
        strRes = strRes.replace("\"pcode\":[]", "\"pcode\":\"\"");
        strRes = strRes.replace("\"pname\":[]", "\"pname\":\"\"");
        strRes = strRes.replace("\"citycode\":[]", "\"citycode\":\"\"");
        strRes = strRes.replace("\"cityname\":[]", "\"cityname\":\"\"");
        strRes = strRes.replace("\"adcode\":[]", "\"adcode\":\"\"");
        strRes = strRes.replace("\"adname\":[]", "\"adname\":\"\"");
        strRes = strRes.replace("\"tel\":[]", "\"tel\":\"\"");
        strRes = strRes.replace("\"address\":[]", "\"address\":\"\"");
        strRes = strRes.replace("\"biz_type\":[]", "\"biz_type\":\"\"");
        strRes = strRes.replace("\"location\":[]", "\"location\":\"\"");
        strRes = strRes.replace("\"distance\":[]", "\"distance\":\"\"");
        strRes = strRes.replace("\"postcode\":[]", "\"postcode\":\"\"");
        strRes = strRes.replace("\"website\":[]", "\"website\":\"\"");
        strRes = strRes.replace("\"email\":[]", "\"email\":\"\"");
        strRes = strRes.replace("\"entr_location\":[]", "\"entr_location\":\"\"");
        strRes = strRes.replace("\"exit_location\":[]", "\"exit_location\":\"\"");
        strRes = strRes.replace("\"navi_poiid\":[]", "\"navi_poiid\":\"\"");
        strRes = strRes.replace("\"gridcode\":[]", "\"gridcode\":\"\"");
        strRes = strRes.replace("\"alias\":[]", "\"alias\":\"\"");
        strRes = strRes.replace("\"business_area\":[]", "\"business_area\":\"\"");
        strRes = strRes.replace("\"tag\":[]", "\"tag\":\"\"");
        return JSON.parseObject(strRes, AmapPoiResultVo.class);
    }


}
