package com.biz.crm.mail.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.mail.service.MailService;
import com.biz.crm.nebular.webservice.mail.CrmMailMessage;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/mail/mailController")
@Api(tags = "电子邮件")
public class MailController {

    @Autowired
    private MailService mailService;

    @ApiOperation(value = "发送邮件")
    @PostMapping("/sendMail")
    @CrmLog
    public Result sendMail(@RequestBody CrmMailMessage crmMailMessage) {
        try {
            mailService.sendMail(crmMailMessage);
        } catch (BusinessException e) {
            log.error("发送邮件失败：{}", e);
            return Result.error(e.getMsg());
        } catch (Exception e) {
            log.error("发送邮件失败：{}", e);
            return Result.error("发送失败");
        }
        return Result.ok();
    }

}
