package com.biz.crm.message.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.util.Result;
import com.biz.crm.util.ShortMessageUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.message.controller
 * @Description: TODO
 * @date 2021/3/24 下午3:44
 */
@Slf4j
@RestController
@RequestMapping("/aliyuncs/shortMessageController")
@Api(tags = "短信消息")
public class ShortMessageController {

    @Autowired
    private ShortMessageUtil shortMessageUtil;


    /**
     * {
     * 	"outId": "",
     * 	"phoneNumbers": "18113494573",
     * 	"regionId": "",
     * 	"signName": "博智维讯",
     * 	"smsUpExtendCode": "",
     * 	"templateCode": "SMS_136420112",
     * 	"templateParam": "{\"code\":\"111222\"}"
     * }
     * @param shortMessage
     * @return
     */
    @ApiOperation(value = "发送短信")
    @PostMapping("/sendMessage")
    @CrmLog
    public Result<Boolean> sendMessage(@RequestBody ShortMessage shortMessage){
        Result<Boolean> result = new Result<>();
        boolean flag =  shortMessageUtil.sendMessage(shortMessage);
        if(flag){
            return Result.ok(flag);
        }else {
            result.error500("发送失败");
            return result;
        }

    }

}
