package com.biz.crm.admin.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobRegistry;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.mapper.XxlJobGroupDao;
import com.biz.crm.admin.mapper.XxlJobInfoDao;
import com.biz.crm.admin.mapper.XxlJobRegistryDao;
import com.biz.crm.common.PageResult;
import com.biz.crm.core.enums.RegistryConfig;
import com.biz.crm.nebular.job.req.JobGroupReqVo;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;

/**
 * job group controller
 *
 * @author xuxueli 2016-10-02 20:52:56
 */
@Controller
@RequestMapping("/jobgroup")
@Api(tags = "执行器管理表;")
public class JobGroupController {

    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobRegistryDao xxlJobRegistryDao;

//    @RequestMapping
//    public String index(Model model) {
//        return "jobgroup/jobgroup.index";
//    }

    @PostMapping("/pageList")
    @ApiOperation(value = "分页查询执行器列表")
    @ResponseBody
    public PageResult<XxlJobGroup> pageList(@RequestBody JobGroupReqVo reqVo) {
        // page query
        Page<XxlJobGroup> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<XxlJobGroup> list = xxlJobGroupDao.pageList(page, reqVo);
        return PageResult.<XxlJobGroup>builder().count(page.getTotal()).data(list).build();
    }

    @PostMapping("/save")
    @ApiOperation(value = "新增执行器")
    @ResponseBody
    public Result save(@RequestBody XxlJobGroup xxlJobGroup) {
        // valid
        AssertUtils.isNotEmpty(xxlJobGroup.getAppName(), "appName不能为空");
        AssertUtils.isNotEmpty(xxlJobGroup.getTitle(), "执行器名称不能为空");
        //校验appName是否重复
        Page<XxlJobGroup> page = PageUtil.buildPage(null,null);
        List<XxlJobGroup> list = xxlJobGroupDao.pageList(page, new JobGroupReqVo().setAppName(xxlJobGroup.getAppName()));
        AssertUtils.isTrue(!CollectionUtil.listNotEmptyNotSizeZero(list),"appName:"+xxlJobGroup.getAppName()+"已经注册过了！");
        if (xxlJobGroup.getAddressType() != 0) {
            AssertUtils.isNotEmpty(xxlJobGroup.getAddressList(), "手动注册时执行器地址不能为空");
            String[] addresss = xxlJobGroup.getAddressList().split(",");
            for (String item : addresss) {
                if (item == null || item.trim().length() == 0) {
                    AssertUtils.isNotEmpty(xxlJobGroup.getAddressList(), "解析执行器地址失败，多个地址应以逗号分隔");
                }
            }
        }
        // process
        xxlJobGroup.setUpdateTime(new Date());
        int ret = xxlJobGroupDao.save(xxlJobGroup);
        return (ret > 0) ? Result.ok() : Result.error("保存失败");
    }

    @PostMapping("/update")
    @ApiOperation(value = "编辑执行器")
    @ResponseBody
    public Result update(@RequestBody XxlJobGroup xxlJobGroup) {
        // valid
        AssertUtils.isNotEmpty(xxlJobGroup.getAppName(), "appName不能为空");
        AssertUtils.isNotEmpty(xxlJobGroup.getTitle(), "执行器名称不能为空");
        //校验appName是否已经被使用
        Page<XxlJobGroup> page = PageUtil.buildPage(null,null);
        List<XxlJobGroup> list = xxlJobGroupDao.pageList(page, new JobGroupReqVo().setAppName(xxlJobGroup.getAppName()));
        AssertUtils.isTrue(!(CollectionUtil.listNotEmptyNotSizeZero(list)&&list.get(0).getId()!=xxlJobGroup.getId()),"appName:"+xxlJobGroup.getAppName()+"已经注册过了！");
        if (xxlJobGroup.getAddressType() == 0) {
            // 0=自动注册
            List<String> registryList = findRegistryByAppName(xxlJobGroup.getAppName());
            String addressListStr = null;
            if (registryList != null && !registryList.isEmpty()) {
                Collections.sort(registryList);
                addressListStr = "";
                for (String item : registryList) {
                    addressListStr += item + ",";
                }
                addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
            }
            xxlJobGroup.setAddressList(addressListStr);
        } else {
            // 1=手动录入
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                AssertUtils.isNotEmpty(xxlJobGroup.getAddressList(), "手动注册时执行器地址不能为空");
            }
            String[] addresss = xxlJobGroup.getAddressList().split(",");
            for (String item : addresss) {
                if (item == null || item.trim().length() == 0) {
                    AssertUtils.isNotEmpty(xxlJobGroup.getAddressList(), "解析执行器地址失败，多个地址应以逗号分隔");
                }
            }
        }
        // process
        xxlJobGroup.setUpdateTime(new Date());
        int ret = xxlJobGroupDao.update(xxlJobGroup);
        return (ret > 0) ? Result.ok("更新成功") : Result.error("更新失败");
    }

    private List<String> findRegistryByAppName(String appNameParam) {
        HashMap<String, List<String>> appAddressMap = new HashMap<String, List<String>>();
        Long times= System.currentTimeMillis()- RegistryConfig.DEAD_TIMEOUT*1000;
        List<XxlJobRegistry> list = xxlJobRegistryDao.findAll( new Date(times));
        if (list != null) {
            for (XxlJobRegistry item : list) {
                if (RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) {
                    String appName = item.getRegistryKey();
                    List<String> registryList = appAddressMap.get(appName);
                    if (registryList == null) {
                        registryList = new ArrayList<String>();
                    }

                    if (!registryList.contains(item.getRegistryValue())) {
                        registryList.add(item.getRegistryValue());
                    }
                    appAddressMap.put(appName, registryList);
                }
            }
        }
        return appAddressMap.get(appNameParam);
    }

    @GetMapping("/remove")
    @ApiOperation(value = "删除执行器")
    @ResponseBody
    public Result remove(String id) {
        List<XxlJobGroup> allList = xxlJobGroupDao.findAll();
        AssertUtils.isTrue(!(allList.size() == 1), I18nUtil.getString("jobgroup_del_limit_1"));
        int ret = xxlJobGroupDao.remove(id);
        return (ret > 0) ? Result.ok("删除成功") : Result.error("删除失败");
    }

    @PostMapping("/loadById")
    @ResponseBody
    @ApiOperation(value = "获取任务的已注册节点")
    public Result<XxlJobGroup> loadById(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotNull(vo.getId(), "任务ID不能为空");
        XxlJobGroup jobGroup = xxlJobGroupDao.load(vo.getId());
        return Result.ok(jobGroup);
    }

    @PostMapping("/getAllJobGroup")
    @ResponseBody
    @ApiOperation("获取执行器列表")
    public Result getJobGroup() {
        return Result.ok(xxlJobGroupDao.findAll());

    }


}
