package com.biz.crm.admin.controller.kms;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobTriggerPoolHelper;
import com.biz.crm.admin.core.trigger.TriggerTypeEnum;
import com.biz.crm.admin.mapper.XxlJobGroupDao;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.core.enums.ExecutorBlockStrategyEnum;
import com.biz.crm.core.glue.GlueTypeEnum;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.admin.controller
 * @ClassName KmsJobController
 * @Author Gavin
 * @Date 2021/4/20 下午3:44
 * @Description kms抓单定时任务接口
 */
@Controller
@RequestMapping("/kms")
@Api(tags = "KMS任务管理表;")
public class KmsJobController {

    @Resource
    private XxlJobService xxlJobService;

    @Resource
    public XxlJobGroupDao xxlJobGroupDao;

    private static final String KMS_EXECUTOR = "xxl-job-executor-kms";

    @PostMapping("/add")
    @ResponseBody
    @ApiOperation("新增任务")
    public Result add(@RequestBody XxlJobInfoReqVo params) {
        XxlJobInfo jobInfo = CrmBeanUtil.copy(params, XxlJobInfo.class);
        //执行器
        LambdaQueryWrapper<XxlJobGroup> build = new LambdaQueryWrapper<XxlJobGroup>()
                .eq(XxlJobGroup::getAppName,KMS_EXECUTOR);
        XxlJobGroup xxlJobGroup = xxlJobGroupDao.selectOne(build);
        if(ObjectUtils.isEmpty(xxlJobGroup)){
            return Result.error("抓单任务执行器[xxl-job-executor-kms]未建立!");
        }
        jobInfo.setJobGroup(xxlJobGroup.getId());
        jobInfo.setScheduleType(ScheduleTypeEnum.CRON.name());
        jobInfo.setGlueType(GlueTypeEnum.BEAN.getDesc());
        jobInfo.setExecutorHandler("kmsJobHandler");
        jobInfo.setExecutorBlockStrategy(ExecutorBlockStrategyEnum.DISCARD_LATER.name());
        jobInfo.setExecutorRouteStrategy(ExecutorRouteStrategyEnum.FIRST.name());
        jobInfo.setMisfireStrategy(MisfireStrategyEnum.DO_NOTHING.name());
        jobInfo.setExecutorTimeout(0);
        jobInfo.setTriggerStatus(1);
        jobInfo.setExecutorFailRetryCount(0);
        XxlJobInfo xxlJobInfo = xxlJobService.add(jobInfo);
        return Result.ok(xxlJobInfo);
    }

    @PostMapping("/update")
    @ResponseBody
    @ApiOperation("修改任务")
    public Result update(@RequestBody XxlJobInfoReqVo params) {
        XxlJobInfo jobInfo = xxlJobService.query(params.getId());
        jobInfo.setAuthor(params.getAuthor());
        jobInfo.setJobDesc(params.getJobDesc());
        jobInfo.setScheduleConf(params.getScheduleConf());
        xxlJobService.update(jobInfo);
        return Result.ok();
    }

    @PostMapping("/remove")
    @ResponseBody
    @ApiOperation("删除任务")
    public Result remove(@RequestBody List<String> ids) {
        xxlJobService.remove(ids);
        return Result.ok();
    }

    @PostMapping("/stop")
    @ResponseBody
    @ApiOperation("停止任务")
    public Result pause(@RequestBody List<String> ids) {
        ids.forEach(id -> xxlJobService.stop(id));
        return Result.ok();
    }

    @PostMapping("/start")
    @ResponseBody
    @ApiOperation("开启任务")
    public Result start(@RequestBody List<String> ids) {
        ids.forEach(id -> xxlJobService.start(id));
        return Result.ok();
    }

    @PostMapping("/trigger")
    @ResponseBody
    @ApiOperation("触发一次任务")
    public Result<Object> triggerJob(@RequestBody XxlJobInfoReqVo vo) {
        // force cover job param
        if (vo.getExecutorParam() == null) {
            vo.setExecutorParam("");
        }

        JobTriggerPoolHelper.trigger(vo.getId(), TriggerTypeEnum.MANUAL, -1, null, vo.getExecutorParam(), vo.getAddressList());
        return Result.ok();
    }
}