package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * Created by xuxueli on 16/9/30.
 */
@TableName("xxl_job_group")
@CrmTable(name = "xxl_job_group",tableNote = "job-执行器")
public class XxlJobGroup  extends BaseIdEntity {

    @ApiModelProperty(value = "appName")
    @CrmColumn(name = "app_name", length = 64,note = "appname")
    private String appName;

    @ApiModelProperty(value = "名称")
    @CrmColumn(name = "title", length = 64,note = "名称")
    private String title;

    @ApiModelProperty(value = "执行器地址类型：0=自动注册、1=手动录入")
    @CrmColumn(name = "address_type", length = 2,note = "执行器地址类型：0=自动注册、1=手动录入")
    private int addressType;        // 执行器地址类型：0=自动注册、1=手动录入

    @ApiModelProperty(value = "执行器地址列表，多地址逗号分隔(手动录入)")
    @CrmColumn(name = "address_list", length = 256,note = "执行器地址列表，多地址逗号分隔(手动录入)")
    private String addressList;     // 执行器地址列表，多地址逗号分隔(手动录入)

    @ApiModelProperty(value = "更新时间")
    @CrmColumn(name = "update_time", note = "更新时间")
    private Date updateTime;

    // registry list
    @TableField(exist = false)
    private List<String> registryList;  // 执行器地址列表(系统注册)
    public List<String> getRegistryList() {
        if (addressList!=null && addressList.trim().length()>0) {
            registryList = new ArrayList<String>(Arrays.asList(addressList.split(",")));
        }
        return registryList;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getAddressType() {
        return addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = addressType;
    }

    public String getAddressList() {
        return addressList;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setAddressList(String addressList) {
        this.addressList = addressList;
    }

}
