package com.biz.crm.admin.core.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * xxl-job log, used to track trigger process
 * @author xuxueli  2015-12-19 23:19:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("xxl_job_log")
@CrmTable(name = "xxl_job_log",tableNote = "job-日志")
public class XxlJobLog extends BaseIdEntity {
	
	// job info
	@CrmColumn(name = "job_group", length = 64,note = "执行器")
	private String jobGroup;

	@CrmColumn(name = "job_id", length = 64,note = "任务id")
	private String jobId;

	// execute info
	@CrmColumn(name = "executor_address", length = 64,note = "执行器地址")
	private String executorAddress;

	@CrmColumn(name = "executor_handler", length = 64,note = "执行handler")
	private String executorHandler;

	@CrmColumn(name = "executor_param", length = 512,note = "执行参数")
	private String executorParam;

	@CrmColumn(name = "executor_sharding_param", length = 64,note = "执行器任务分片参数,格式如 1/2")
	private String executorShardingParam;

	@CrmColumn(name = "executor_fail_retry_count", length = 64,note = "失败重试次数")
	private int executorFailRetryCount;
	
	// trigger info
	@CrmColumn(name = "trigger_time", note = "调度时间")
	private Date triggerTime;

	@CrmColumn(name = "trigger_code", length = 64,note = "调度返回码")
	private int triggerCode;

	@CrmColumn(name = "trigger_msg", length = 4000,note = "调度返回结果")
	private String triggerMsg;
	
	// handle info
	@CrmColumn(name = "handle_code", note = "执行时间")
	private Date handleTime;

	@CrmColumn(name = "handle_code", length = 64,note = "执行返回码")
	private int handleCode;

	@CrmColumn(name = "handle_msg", length = 4000,note = "调度结果")
	private String handleMsg;

	// alarm info
	private int alarmStatus;

}
