/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.service;

import com.biz.crm.admin.core.model.XxlJobUser;
import com.biz.crm.admin.core.util.CookieUtil;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.core.util.JacksonUtil;
import com.biz.crm.admin.dao.XxlJobUserDao;
import com.xxl.job.core.biz.model.ReturnT;
import java.math.BigInteger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.DigestUtils;

@Configuration
public class LoginService {
    public static final String LOGIN_IDENTITY_KEY = "XXL_JOB_LOGIN_IDENTITY";
    @Resource
    private XxlJobUserDao xxlJobUserDao;

    private String makeToken(XxlJobUser xxlJobUser) {
        String tokenJson = JacksonUtil.writeValueAsString(xxlJobUser);
        String tokenHex = new BigInteger(tokenJson.getBytes()).toString(16);
        return tokenHex;
    }

    private XxlJobUser parseToken(String tokenHex) {
        XxlJobUser xxlJobUser = null;
        if (tokenHex != null) {
            String tokenJson = new String(new BigInteger(tokenHex, 16).toByteArray());
            xxlJobUser = JacksonUtil.readValue(tokenJson, XxlJobUser.class);
        }
        return xxlJobUser;
    }

    public ReturnT<String> login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean ifRemember) {
        if (username == null || username.trim().length() == 0 || password == null || password.trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("login_param_empty"));
        }
        XxlJobUser xxlJobUser = this.xxlJobUserDao.loadByUserName(username);
        if (xxlJobUser == null) {
            return new ReturnT(500, I18nUtil.getString("login_param_unvalid"));
        }
        String passwordMd5 = DigestUtils.md5DigestAsHex((byte[])password.getBytes());
        if (!passwordMd5.equals(xxlJobUser.getPassword())) {
            return new ReturnT(500, I18nUtil.getString("login_param_unvalid"));
        }
        String loginToken = this.makeToken(xxlJobUser);
        CookieUtil.set(response, LOGIN_IDENTITY_KEY, loginToken, ifRemember);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> logout(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.remove(request, response, LOGIN_IDENTITY_KEY);
        return ReturnT.SUCCESS;
    }

    public XxlJobUser ifLogin(HttpServletRequest request, HttpServletResponse response) {
        String cookieToken = CookieUtil.getValue(request, LOGIN_IDENTITY_KEY);
        if (cookieToken != null) {
            XxlJobUser dbUser;
            XxlJobUser cookieUser = null;
            try {
                cookieUser = this.parseToken(cookieToken);
            }
            catch (Exception e) {
                this.logout(request, response);
            }
            if (cookieUser != null && (dbUser = this.xxlJobUserDao.loadByUserName(cookieUser.getUsername())) != null && cookieUser.getPassword().equals(dbUser.getPassword())) {
                return dbUser;
            }
        }
        return null;
    }
}

