/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller.interceptor;

import com.biz.crm.admin.controller.annotation.PermissionLimit;
import com.biz.crm.admin.core.model.XxlJobUser;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.service.LoginService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PermissionInterceptor
extends HandlerInterceptorAdapter {
    @Resource
    private LoginService loginService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return super.preHandle(request, response, handler);
        }
        boolean needLogin = true;
        boolean needAdminuser = false;
        HandlerMethod method = (HandlerMethod)handler;
        PermissionLimit permission = (PermissionLimit)method.getMethodAnnotation(PermissionLimit.class);
        if (permission != null) {
            needLogin = permission.limit();
            needAdminuser = permission.adminuser();
        }
        if (needLogin) {
            XxlJobUser loginUser = this.loginService.ifLogin(request, response);
            if (loginUser == null) {
                response.setStatus(302);
                response.setHeader("location", request.getContextPath() + "/toLogin");
                return false;
            }
            if (needAdminuser && loginUser.getRole() != 1) {
                throw new RuntimeException(I18nUtil.getString("system_permission_limit"));
            }
            request.setAttribute("XXL_JOB_LOGIN_IDENTITY", (Object)loginUser);
        }
        return super.preHandle(request, response, handler);
    }
}

