/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.conf;

import com.biz.crm.admin.core.alarm.JobAlarmer;
import com.biz.crm.admin.core.scheduler.XxlJobScheduler;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobLogDao;
import com.biz.crm.admin.dao.XxlJobLogReportDao;
import com.biz.crm.admin.dao.XxlJobRegistryDao;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

@Component
public class XxlJobAdminConfig
implements InitializingBean,
DisposableBean {
    private static XxlJobAdminConfig adminConfig = null;
    private XxlJobScheduler xxlJobScheduler;
    @Value(value="${xxl.job.i18n}")
    private String i18n;
    @Value(value="${xxl.job.accessToken}")
    private String accessToken;
    @Value(value="${spring.mail.from}")
    private String emailFrom;
    @Value(value="${xxl.job.triggerpool.fast.max}")
    private int triggerPoolFastMax;
    @Value(value="${xxl.job.triggerpool.slow.max}")
    private int triggerPoolSlowMax;
    @Value(value="${xxl.job.logretentiondays}")
    private int logretentiondays;
    @Resource
    private XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobRegistryDao xxlJobRegistryDao;
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobLogReportDao xxlJobLogReportDao;
    @Resource
    private JavaMailSender mailSender;
    @Resource
    private DataSource dataSource;
    @Resource
    private JobAlarmer jobAlarmer;

    public static XxlJobAdminConfig getAdminConfig() {
        return adminConfig;
    }

    public void afterPropertiesSet() throws Exception {
        adminConfig = this;
        this.xxlJobScheduler = new XxlJobScheduler();
        this.xxlJobScheduler.init();
    }

    public void destroy() throws Exception {
        this.xxlJobScheduler.destroy();
    }

    public String getI18n() {
        if (!Arrays.asList("zh_CN", "zh_TC", "en").contains(this.i18n)) {
            return "zh_CN";
        }
        return this.i18n;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public int getTriggerPoolFastMax() {
        return this.triggerPoolFastMax;
    }

    public int getTriggerPoolSlowMax() {
        return this.triggerPoolSlowMax;
    }

    public int getLogretentiondays() {
        if (this.logretentiondays < 7) {
            return -1;
        }
        return this.logretentiondays;
    }

    public XxlJobLogDao getXxlJobLogDao() {
        return this.xxlJobLogDao;
    }

    public XxlJobInfoDao getXxlJobInfoDao() {
        return this.xxlJobInfoDao;
    }

    public XxlJobRegistryDao getXxlJobRegistryDao() {
        return this.xxlJobRegistryDao;
    }

    public XxlJobGroupDao getXxlJobGroupDao() {
        return this.xxlJobGroupDao;
    }

    public XxlJobLogReportDao getXxlJobLogReportDao() {
        return this.xxlJobLogReportDao;
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JobAlarmer getJobAlarmer() {
        return this.jobAlarmer;
    }
}

