/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.cron.CronExpression;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobInfo;
import com.biz.crm.admin.core.model.XxlJobLogReport;
import com.biz.crm.admin.core.route.ExecutorRouteStrategyEnum;
import com.biz.crm.admin.core.scheduler.MisfireStrategyEnum;
import com.biz.crm.admin.core.scheduler.ScheduleTypeEnum;
import com.biz.crm.admin.core.thread.JobScheduleHelper;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobLogDao;
import com.biz.crm.admin.dao.XxlJobLogGlueDao;
import com.biz.crm.admin.dao.XxlJobLogReportDao;
import com.biz.crm.admin.service.XxlJobService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.job.JobColumn;
import com.biz.crm.eunm.job.JobColumnStr;
import com.biz.crm.nebular.job.req.JobChartInfoReqVo;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.job.resp.JobChartInfoInfoRespVo;
import com.biz.crm.nebular.job.resp.JobStatisticsInfoRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import com.xxl.job.core.glue.GlueTypeEnum;
import com.xxl.job.core.util.DateUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static Logger logger = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;
    @Resource
    private XxlJobLogReportDao xxlJobLogReportDao;

    @Override
    public PageResult<XxlJobInfo> pageList(XxlJobInfoReqVo xxlJobInfoReqVo) {
        Page page = PageUtil.buildPage((Integer)xxlJobInfoReqVo.getPageNum(), (Integer)xxlJobInfoReqVo.getPageSize());
        List<XxlJobInfo> list = this.xxlJobInfoDao.pageList((Page<XxlJobInfo>)page, xxlJobInfoReqVo);
        list.forEach(xxlJobInfo -> xxlJobInfo.setTriggerStatusValue(JobColumn.TRIGGER_STATUS.getLabelByCode(Integer.valueOf(xxlJobInfo.getTriggerStatus()))));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public XxlJobInfo query(Integer id) {
        return this.xxlJobInfoDao.loadById(id);
    }

    @Override
    public void add(XxlJobInfo jobInfo) {
        XxlJobGroup group = this.xxlJobGroupDao.load(jobInfo.getJobGroup());
        AssertUtils.isNotNull((Object)group, (String)"\u8bf7\u9009\u62e9\u6267\u884c\u5668\uff01");
        AssertUtils.isNotEmpty((String)jobInfo.getJobDesc(), (String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u63cf\u8ff0\uff01");
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(jobInfo.getScheduleType(), null);
        AssertUtils.isNotNull((Object)((Object)scheduleTypeEnum), (String)"\u8c03\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        if (scheduleTypeEnum == ScheduleTypeEnum.CRON) {
            if (jobInfo.getScheduleConf() == null || !CronExpression.isValidExpression(jobInfo.getScheduleConf())) {
                throw new BusinessException("Cron\u975e\u6cd5\uff01");
            }
        } else if (scheduleTypeEnum == ScheduleTypeEnum.FIX_RATE) {
            AssertUtils.isNotEmpty((String)jobInfo.getScheduleConf(), (String)"\u8c03\u5ea6\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                int fixSecond = Integer.parseInt(jobInfo.getScheduleConf());
                if (fixSecond < 1) {
                    throw new BusinessException("\u8c03\u5ea6\u7c7b\u578b\u975e\u6cd5");
                }
            }
            catch (Exception e) {
                throw new BusinessException("\u8c03\u5ea6\u7c7b\u578b\u975e\u6cd5");
            }
        }
        AssertUtils.isNotNull((Object)GlueTypeEnum.match((String)jobInfo.getGlueType()), (String)"\u8fd0\u884c\u6a21\u5f0f\u975e\u6cd5");
        AssertUtils.isTrue((GlueTypeEnum.BEAN != GlueTypeEnum.match((String)jobInfo.getGlueType()) || jobInfo.getExecutorHandler() != null && jobInfo.getExecutorHandler().trim().length() != 0 ? 1 : 0) != 0, (String)"\u8bf7\u8f93\u5165JobHandler");
        if (GlueTypeEnum.GLUE_SHELL == GlueTypeEnum.match((String)jobInfo.getGlueType()) && jobInfo.getGlueSource() != null) {
            jobInfo.setGlueSource(jobInfo.getGlueSource().replaceAll("\r", ""));
        }
        AssertUtils.isNotNull((Object)((Object)ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null)), (String)"\u8def\u7531\u7b56\u7565\u975e\u6cd5");
        AssertUtils.isNotNull((Object)((Object)MisfireStrategyEnum.match(jobInfo.getMisfireStrategy(), null)), (String)"\u8c03\u5ea6\u8fc7\u671f\u7b56\u7565\u975e\u6cd5");
        AssertUtils.isNotNull((Object)ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null), (String)"\u963b\u585e\u5904\u7406\u7b56\u7565\u975e\u6cd5");
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem == null || childJobIdItem.trim().length() <= 0 || !this.isNumeric(childJobIdItem)) {
                    throw new BusinessException("\u5b50\u4efb\u52a1ID({0})\u975e\u6cd5");
                }
                XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                AssertUtils.isNotNull((Object)childJobInfo, (String)"\u5b50\u4efb\u52a1ID({0})\u4e0d\u5b58\u5728");
            }
            StringBuilder temp = new StringBuilder();
            for (String item : childJobIds) {
                temp.append(item).append(",");
            }
            temp = new StringBuilder(temp.substring(0, temp.length() - 1));
            jobInfo.setChildJobId(temp.toString());
        }
        jobInfo.setAddTime(new Date());
        jobInfo.setUpdateTime(new Date());
        jobInfo.setGlueUpdatetime(new Date());
        jobInfo.setGlueSource(JobColumnStr.GLUE_SOURCE.getLabelByCode(jobInfo.getGlueType()));
        this.xxlJobInfoDao.insert(jobInfo);
        if (jobInfo.getId() < 1) {
            throw new BusinessException(I18nUtil.getString("\u65b0\u589e") + I18nUtil.getString("\u5931\u8d25"));
        }
    }

    private boolean isNumeric(String str) {
        try {
            int result = Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public ReturnT<String> update(XxlJobInfo jobInfo) {
        boolean scheduleDataNotChanged;
        XxlJobGroup jobGroup;
        if (jobInfo.getJobDesc() == null || jobInfo.getJobDesc().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("\u8bf7\u8f93\u5165") + I18nUtil.getString("\u4efb\u52a1\u63cf\u8ff0"));
        }
        if (jobInfo.getAuthor() == null || jobInfo.getAuthor().trim().length() == 0) {
            return new ReturnT(500, I18nUtil.getString("\u8bf7\u8f93\u5165") + I18nUtil.getString("\u8d1f\u8d23\u4eba"));
        }
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(jobInfo.getScheduleType(), null);
        if (scheduleTypeEnum == null) {
            return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
        }
        if (scheduleTypeEnum == ScheduleTypeEnum.CRON) {
            if (jobInfo.getScheduleConf() == null || !CronExpression.isValidExpression(jobInfo.getScheduleConf())) {
                return new ReturnT(500, "Cron" + I18nUtil.getString("\u975e\u6cd5"));
            }
        } else if (scheduleTypeEnum == ScheduleTypeEnum.FIX_RATE) {
            if (jobInfo.getScheduleConf() == null) {
                return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
            }
            try {
                int fixSecond = Integer.valueOf(jobInfo.getScheduleConf());
                if (fixSecond < 1) {
                    return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
                }
            }
            catch (Exception e) {
                return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
            }
        }
        if (ExecutorRouteStrategyEnum.match(jobInfo.getExecutorRouteStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("\u8def\u7531\u7b56\u7565") + I18nUtil.getString("\u975e\u6cd5"));
        }
        if (MisfireStrategyEnum.match(jobInfo.getMisfireStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u8fc7\u671f\u7b56\u7565") + I18nUtil.getString("\u975e\u6cd5"));
        }
        if (ExecutorBlockStrategyEnum.match((String)jobInfo.getExecutorBlockStrategy(), null) == null) {
            return new ReturnT(500, I18nUtil.getString("\u963b\u585e\u5904\u7406\u7b56\u7565") + I18nUtil.getString("\u975e\u6cd5"));
        }
        if (jobInfo.getChildJobId() != null && jobInfo.getChildJobId().trim().length() > 0) {
            String[] childJobIds;
            for (String childJobIdItem : childJobIds = jobInfo.getChildJobId().split(",")) {
                if (childJobIdItem != null && childJobIdItem.trim().length() > 0 && this.isNumeric(childJobIdItem)) {
                    XxlJobInfo childJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(childJobIdItem));
                    if (childJobInfo != null) continue;
                    return new ReturnT(500, MessageFormat.format(I18nUtil.getString("\u5b50\u4efb\u52a1ID") + "({0})" + I18nUtil.getString("\u4e0d\u5b58\u5728"), childJobIdItem));
                }
                return new ReturnT(500, MessageFormat.format(I18nUtil.getString("\u5b50\u4efb\u52a1ID") + "({0})" + I18nUtil.getString("\u975e\u6cd5"), childJobIdItem));
            }
            String temp = "";
            for (String item : childJobIds) {
                temp = temp + item + ",";
            }
            temp = temp.substring(0, temp.length() - 1);
            jobInfo.setChildJobId(temp);
        }
        if ((jobGroup = this.xxlJobGroupDao.load(jobInfo.getJobGroup())) == null) {
            return new ReturnT(500, I18nUtil.getString("\u6267\u884c\u5668") + I18nUtil.getString("\u975e\u6cd5"));
        }
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(jobInfo.getId());
        if (exists_jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString("jobinfo_field_id") + I18nUtil.getString("\u4e0d\u5b58\u5728"));
        }
        long nextTriggerTime = exists_jobInfo.getTriggerNextTime();
        boolean bl = scheduleDataNotChanged = jobInfo.getScheduleType().equals(exists_jobInfo.getScheduleType()) && jobInfo.getScheduleConf().equals(exists_jobInfo.getScheduleConf());
        if (exists_jobInfo.getTriggerStatus() == 1 && !scheduleDataNotChanged) {
            try {
                Date nextValidTime = JobScheduleHelper.generateNextValidTime(jobInfo, new Date(System.currentTimeMillis() + 5000L));
                if (nextValidTime == null) {
                    return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
                }
                nextTriggerTime = nextValidTime.getTime();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
            }
        }
        exists_jobInfo.setJobGroup(jobInfo.getJobGroup());
        exists_jobInfo.setJobDesc(jobInfo.getJobDesc());
        exists_jobInfo.setAuthor(jobInfo.getAuthor());
        exists_jobInfo.setAlarmEmail(jobInfo.getAlarmEmail());
        exists_jobInfo.setScheduleType(jobInfo.getScheduleType());
        exists_jobInfo.setScheduleConf(jobInfo.getScheduleConf());
        exists_jobInfo.setMisfireStrategy(jobInfo.getMisfireStrategy());
        exists_jobInfo.setExecutorRouteStrategy(jobInfo.getExecutorRouteStrategy());
        exists_jobInfo.setExecutorHandler(jobInfo.getExecutorHandler());
        exists_jobInfo.setExecutorParam(jobInfo.getExecutorParam());
        exists_jobInfo.setExecutorBlockStrategy(jobInfo.getExecutorBlockStrategy());
        exists_jobInfo.setExecutorTimeout(jobInfo.getExecutorTimeout());
        exists_jobInfo.setExecutorFailRetryCount(jobInfo.getExecutorFailRetryCount());
        exists_jobInfo.setChildJobId(jobInfo.getChildJobId());
        exists_jobInfo.setTriggerNextTime(nextTriggerTime);
        exists_jobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.updateById(exists_jobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    @Transactional
    public void remove(List<String> ids) {
        ids.forEach(id -> {
            XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(Integer.parseInt(id));
            if (xxlJobInfo != null) {
                this.xxlJobInfoDao.delete(Long.parseLong(id));
                this.xxlJobLogDao.delete(Integer.parseInt(id));
                this.xxlJobLogGlueDao.deleteByJobId(Integer.parseInt(id));
            }
        });
    }

    @Override
    public ReturnT<String> start(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        ScheduleTypeEnum scheduleTypeEnum = ScheduleTypeEnum.match(xxlJobInfo.getScheduleType(), ScheduleTypeEnum.NONE);
        if (ScheduleTypeEnum.NONE == scheduleTypeEnum) {
            return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b_none_limit_start"));
        }
        long nextTriggerTime = 0L;
        try {
            Date nextValidTime = JobScheduleHelper.generateNextValidTime(xxlJobInfo, new Date(System.currentTimeMillis() + 5000L));
            if (nextValidTime == null) {
                return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
            }
            nextTriggerTime = nextValidTime.getTime();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ReturnT(500, I18nUtil.getString("\u8c03\u5ea6\u7c7b\u578b") + I18nUtil.getString("\u975e\u6cd5"));
        }
        xxlJobInfo.setTriggerStatus(1);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(nextTriggerTime);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.updateById(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    public ReturnT<String> stop(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        xxlJobInfo.setTriggerStatus(0);
        xxlJobInfo.setTriggerLastTime(0L);
        xxlJobInfo.setTriggerNextTime(0L);
        xxlJobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.updateById(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    @Override
    public JobStatisticsInfoRespVo statisticsInfo() {
        int jobLogCount = 0;
        XxlJobLogReport xxlJobLogReport = this.xxlJobLogReportDao.queryLogReportTotal();
        if (xxlJobLogReport != null) {
            jobLogCount = xxlJobLogReport.getRunningCount() + xxlJobLogReport.getSucCount() + xxlJobLogReport.getFailCount();
        }
        HashSet<String> executorAddressSet = new HashSet<String>();
        List<XxlJobGroup> groupList = this.xxlJobGroupDao.findAll();
        if (groupList != null && !groupList.isEmpty()) {
            for (XxlJobGroup group : groupList) {
                if (group.getRegistryList() == null || group.getRegistryList().isEmpty()) continue;
                executorAddressSet.addAll(group.getRegistryList());
            }
        }
        return new JobStatisticsInfoRespVo().setJobInfoCount(Integer.valueOf(this.xxlJobInfoDao.findAllCount())).setJobLogCount(Integer.valueOf(jobLogCount)).setExecutorCount(Integer.valueOf(executorAddressSet.size()));
    }

    @Override
    public JobChartInfoInfoRespVo chartInfo(JobChartInfoReqVo reqVo) {
        ArrayList triggerDayList = Lists.newArrayList();
        ArrayList triggerDayCountRunningList = Lists.newArrayList();
        ArrayList triggerDayCountSucList = Lists.newArrayList();
        ArrayList triggerDayCountFailList = Lists.newArrayList();
        int triggerCountRunningTotal = 0;
        int triggerCountSucTotal = 0;
        int triggerCountFailTotal = 0;
        List<XxlJobLogReport> logReportList = this.xxlJobLogReportDao.queryLogReport(reqVo.getStartTime(), reqVo.getEndTime());
        if (logReportList != null && logReportList.size() > 0) {
            for (XxlJobLogReport item : logReportList) {
                String day = DateUtil.formatDate((Date)item.getTriggerDay());
                int triggerDayCountRunning = item.getRunningCount();
                int triggerDayCountSuc = item.getSucCount();
                int triggerDayCountFail = item.getFailCount();
                triggerDayList.add(day);
                triggerDayCountRunningList.add(triggerDayCountRunning);
                triggerDayCountSucList.add(triggerDayCountSuc);
                triggerDayCountFailList.add(triggerDayCountFail);
                triggerCountRunningTotal += triggerDayCountRunning;
                triggerCountSucTotal += triggerDayCountSuc;
                triggerCountFailTotal += triggerDayCountFail;
            }
        } else {
            for (int i = -6; i <= 0; ++i) {
                triggerDayList.add(DateUtil.formatDate((Date)DateUtil.addDays((Date)new Date(), (int)i)));
                triggerDayCountRunningList.add(0);
                triggerDayCountSucList.add(0);
                triggerDayCountFailList.add(0);
            }
        }
        return new JobChartInfoInfoRespVo().setTriggerDayList((List)triggerDayList).setTriggerDayCountRunningList((List)triggerDayCountRunningList).setTriggerDayCountSucList((List)triggerDayCountSucList).setTriggerDayCountFailList((List)triggerDayCountFailList).setTriggerCountRunningTotal(Integer.valueOf(triggerCountRunningTotal)).setTriggerCountSucTotal(Integer.valueOf(triggerCountSucTotal)).setTriggerCountFailTotal(Integer.valueOf(triggerCountFailTotal));
    }
}

