/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.core.thread;

import com.biz.crm.admin.core.complete.XxlJobCompleter;
import com.biz.crm.admin.core.conf.XxlJobAdminConfig;
import com.biz.crm.admin.core.model.XxlJobLog;
import com.biz.crm.admin.core.util.I18nUtil;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCompleteHelper {
    private static Logger logger = LoggerFactory.getLogger(JobCompleteHelper.class);
    private static JobCompleteHelper instance = new JobCompleteHelper();
    private ThreadPoolExecutor callbackThreadPool = null;
    private Thread monitorThread;
    private volatile boolean toStop = false;

    public static JobCompleteHelper getInstance() {
        return instance;
    }

    public void start() {
        this.callbackThreadPool = new ThreadPoolExecutor(2, 20, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(3000), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "xxl-job, admin JobLosedMonitorHelper-callbackThreadPool-" + r.hashCode());
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                r.run();
                logger.warn(">>>>>>>>>>> xxl-job, callback too fast, match threadpool rejected handler(run now).");
            }
        });
        this.monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        TimeUnit.MILLISECONDS.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        if (JobCompleteHelper.this.toStop) break block9;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                while (!JobCompleteHelper.this.toStop) {
                    block10: {
                        try {
                            Date losedTime = DateUtil.addMinutes((Date)new Date(), (int)-10);
                            List<Long> losedJobIds = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().findLostJobIds(losedTime);
                            if (losedJobIds != null && losedJobIds.size() > 0) {
                                for (Long logId : losedJobIds) {
                                    XxlJobLog jobLog = new XxlJobLog();
                                    jobLog.setId(logId);
                                    jobLog.setHandleTime(new Date());
                                    jobLog.setHandleCode(500);
                                    jobLog.setHandleMsg(I18nUtil.getString("joblog_lost_fail"));
                                    XxlJobCompleter.updateHandleInfoAndFinish(jobLog);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (JobCompleteHelper.this.toStop) break block10;
                            logger.error(">>>>>>>>>>> xxl-job, job fail monitor thread error:{}", (Throwable)e);
                        }
                    }
                    try {
                        TimeUnit.SECONDS.sleep(60L);
                    }
                    catch (Exception e) {
                        if (JobCompleteHelper.this.toStop) continue;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>>> xxl-job, JobLosedMonitorHelper stop");
            }
        });
        this.monitorThread.setDaemon(true);
        this.monitorThread.setName("xxl-job, admin JobLosedMonitorHelper");
        this.monitorThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.callbackThreadPool.shutdownNow();
        this.monitorThread.interrupt();
        try {
            this.monitorThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public ReturnT<String> callback(final List<HandleCallbackParam> callbackParamList) {
        this.callbackThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                for (HandleCallbackParam handleCallbackParam : callbackParamList) {
                    ReturnT callbackResult = JobCompleteHelper.this.callback(handleCallbackParam);
                    logger.debug(">>>>>>>>> JobApiController.callback {}, handleCallbackParam={}, callbackResult={}", new Object[]{callbackResult.getCode() == 200 ? "success" : "fail", handleCallbackParam, callbackResult});
                }
            }
        });
        return ReturnT.SUCCESS;
    }

    private ReturnT<String> callback(HandleCallbackParam handleCallbackParam) {
        XxlJobLog log = XxlJobAdminConfig.getAdminConfig().getXxlJobLogDao().load(handleCallbackParam.getLogId());
        if (log == null) {
            return new ReturnT(500, "log item not found.");
        }
        if (log.getHandleCode() > 0) {
            return new ReturnT(500, "log repeate callback.");
        }
        StringBuffer handleMsg = new StringBuffer();
        if (log.getHandleMsg() != null) {
            handleMsg.append(log.getHandleMsg()).append("<br>");
        }
        log.setHandleTime(new Date());
        log.setHandleMsg(handleMsg.toString());
        XxlJobCompleter.updateHandleInfoAndFinish(log);
        return ReturnT.SUCCESS;
    }
}

