/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.admin.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.admin.core.model.XxlJobGroup;
import com.biz.crm.admin.core.model.XxlJobRegistry;
import com.biz.crm.admin.core.util.I18nUtil;
import com.biz.crm.admin.dao.XxlJobGroupDao;
import com.biz.crm.admin.dao.XxlJobInfoDao;
import com.biz.crm.admin.dao.XxlJobRegistryDao;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.job.req.JobGroupReqVo;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.xxl.job.core.enums.RegistryConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobgroup"})
@Api(tags={"\u6267\u884c\u5668\u7ba1\u7406\u8868;"})
public class JobGroupController {
    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobRegistryDao xxlJobRegistryDao;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6267\u884c\u5668\u5217\u8868")
    @ResponseBody
    public PageResult<XxlJobGroup> pageList(@RequestBody JobGroupReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<XxlJobGroup> list = this.xxlJobGroupDao.pageList((Page<XxlJobGroup>)page, reqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e\u6267\u884c\u5668")
    @ResponseBody
    public Result save(@RequestBody XxlJobGroup xxlJobGroup) {
        AssertUtils.isNotEmpty((String)xxlJobGroup.getAppName(), (String)"appName\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)xxlJobGroup.getTitle(), (String)"\u6267\u884c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage(null, null);
        List<XxlJobGroup> list = this.xxlJobGroupDao.pageList((Page<XxlJobGroup>)page, new JobGroupReqVo().setAppName(xxlJobGroup.getAppName()));
        AssertUtils.isTrue((!CollectionUtil.listNotEmptyNotSizeZero(list) ? 1 : 0) != 0, (String)("appName:" + xxlJobGroup.getAppName() + "\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86\uff01"));
        if (xxlJobGroup.getAddressType() != 0) {
            String[] addresss;
            AssertUtils.isNotEmpty((String)xxlJobGroup.getAddressList(), (String)"\u624b\u52a8\u6ce8\u518c\u65f6\u6267\u884c\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                AssertUtils.isNotEmpty((String)xxlJobGroup.getAddressList(), (String)"\u89e3\u6790\u6267\u884c\u5668\u5730\u5740\u5931\u8d25\uff0c\u591a\u4e2a\u5730\u5740\u5e94\u4ee5\u9017\u53f7\u5206\u9694");
            }
        }
        xxlJobGroup.setUpdateTime(new Date());
        int ret = this.xxlJobGroupDao.save(xxlJobGroup);
        return ret > 0 ? Result.ok() : Result.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u7f16\u8f91\u6267\u884c\u5668")
    @ResponseBody
    public Result update(@RequestBody XxlJobGroup xxlJobGroup) {
        AssertUtils.isNotEmpty((String)xxlJobGroup.getAppName(), (String)"appName\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)xxlJobGroup.getTitle(), (String)"\u6267\u884c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage(null, null);
        List<XxlJobGroup> list = this.xxlJobGroupDao.pageList((Page<XxlJobGroup>)page, new JobGroupReqVo().setAppName(xxlJobGroup.getAppName()));
        AssertUtils.isTrue((!CollectionUtil.listNotEmptyNotSizeZero(list) || list.get(0).getId() == xxlJobGroup.getId() ? 1 : 0) != 0, (String)("appName:" + xxlJobGroup.getAppName() + "\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86\uff01"));
        if (xxlJobGroup.getAddressType() == 0) {
            List<String> registryList = this.findRegistryByAppName(xxlJobGroup.getAppName());
            String addressListStr = null;
            if (registryList != null && !registryList.isEmpty()) {
                Collections.sort(registryList);
                addressListStr = "";
                for (String item : registryList) {
                    addressListStr = addressListStr + item + ",";
                }
                addressListStr = addressListStr.substring(0, addressListStr.length() - 1);
            }
            xxlJobGroup.setAddressList(addressListStr);
        } else {
            String[] addresss;
            if (xxlJobGroup.getAddressList() == null || xxlJobGroup.getAddressList().trim().length() == 0) {
                AssertUtils.isNotEmpty((String)xxlJobGroup.getAddressList(), (String)"\u624b\u52a8\u6ce8\u518c\u65f6\u6267\u884c\u5668\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (String item : addresss = xxlJobGroup.getAddressList().split(",")) {
                if (item != null && item.trim().length() != 0) continue;
                AssertUtils.isNotEmpty((String)xxlJobGroup.getAddressList(), (String)"\u89e3\u6790\u6267\u884c\u5668\u5730\u5740\u5931\u8d25\uff0c\u591a\u4e2a\u5730\u5740\u5e94\u4ee5\u9017\u53f7\u5206\u9694");
            }
        }
        xxlJobGroup.setUpdateTime(new Date());
        int ret = this.xxlJobGroupDao.update(xxlJobGroup);
        return ret > 0 ? Result.ok((String)"\u66f4\u65b0\u6210\u529f") : Result.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    private List<String> findRegistryByAppName(String appNameParam) {
        HashMap appAddressMap = new HashMap();
        Long times = System.currentTimeMillis() - 90000L;
        List<XxlJobRegistry> list = this.xxlJobRegistryDao.findAll(new Date(times));
        if (list != null) {
            for (XxlJobRegistry item : list) {
                if (!RegistryConfig.RegistType.EXECUTOR.name().equals(item.getRegistryGroup())) continue;
                String appName = item.getRegistryKey();
                ArrayList<String> registryList = (ArrayList<String>)appAddressMap.get(appName);
                if (registryList == null) {
                    registryList = new ArrayList<String>();
                }
                if (!registryList.contains(item.getRegistryValue())) {
                    registryList.add(item.getRegistryValue());
                }
                appAddressMap.put(appName, registryList);
            }
        }
        return (List)appAddressMap.get(appNameParam);
    }

    @GetMapping(value={"/remove"})
    @ApiOperation(value="\u5220\u9664\u6267\u884c\u5668")
    @ResponseBody
    public Result remove(int id) {
        List<XxlJobGroup> allList = this.xxlJobGroupDao.findAll();
        AssertUtils.isTrue((allList.size() != 1 ? 1 : 0) != 0, (String)I18nUtil.getString("jobgroup_del_limit_1"));
        int ret = this.xxlJobGroupDao.remove(id);
        return ret > 0 ? Result.ok((String)"\u5220\u9664\u6210\u529f") : Result.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"/loadById"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u5df2\u6ce8\u518c\u8282\u70b9")
    public Result<XxlJobGroup> loadById(@RequestBody XxlJobInfoReqVo vo) {
        AssertUtils.isNotNull((Object)vo.getId(), (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        XxlJobGroup jobGroup = this.xxlJobGroupDao.load(Integer.parseInt(vo.getId()));
        return Result.ok((Object)jobGroup);
    }

    @PostMapping(value={"/getAllJobGroup"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6267\u884c\u5668\u5217\u8868")
    public Result getJobGroup() {
        return Result.ok(this.xxlJobGroupDao.findAll());
    }
}

