/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.page;

import java.io.Serializable;
import java.util.List;

public class PageResult<E>
implements Serializable {
    private int currentPage = 1;
    private int size = 10;
    private List<E> result;
    private int total;

    public PageResult(int currentPage, int size, long total, List<E> result) {
        if (result == null) {
            throw new NullPointerException("\u5206\u9875\u7ed3\u679c\u4e0d\u80fd\u4e3a null");
        }
        this.currentPage = currentPage;
        this.size = size;
        this.result = result;
        this.total = (int)total;
        this.currentPage = Math.min(currentPage, this.getTotalPages());
    }

    public PageResult() {
    }

    public List<E> getResult() {
        return this.result;
    }

    public void setResult(List<E> result) {
        this.result = result;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = Math.min(currentPage, this.getTotalPages());
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        this.currentPage = Math.min(this.currentPage, this.getTotalPages());
    }

    public int getTotalPages() {
        int totalPages = this.getTotal() / this.getSize() + (this.getTotal() % this.getSize() == 0 ? 0 : 1);
        return totalPages;
    }
}

