/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.page;

import java.io.Serializable;
import java.util.ArrayList;

public class Pagination
implements Serializable {
    private static final long serialVersionUID = -5170954438350002910L;
    private static final int DEFAULT_SLIDERS_COUNT = 5;
    private int limit;
    private int page;
    private int totalCount;

    public Pagination(int page, int limit, int totalCount) {
        this.limit = limit;
        this.totalCount = totalCount;
        this.page = this.computePageNo(page);
    }

    public int getPage() {
        return this.page;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isFirstPage() {
        return this.page <= 1;
    }

    public boolean isLastPage() {
        return this.page >= this.getTotalPages();
    }

    public int getPrePage() {
        if (this.isHasPrePage()) {
            return this.page - 1;
        }
        return this.page;
    }

    public int getNextPage() {
        if (this.isHasNextPage()) {
            return this.page + 1;
        }
        return this.page;
    }

    public boolean isDisabledPage(int page) {
        return page < 1 || page > this.getTotalPages() || page == this.page;
    }

    public boolean isHasPrePage() {
        return this.page - 1 >= 1;
    }

    public boolean isHasNextPage() {
        return this.page + 1 <= this.getTotalPages();
    }

    public int getTotalPages() {
        if (this.totalCount <= 0) {
            return 0;
        }
        if (this.limit <= 0) {
            return 0;
        }
        int count = this.totalCount / this.limit;
        if (this.totalCount % this.limit > 0) {
            ++count;
        }
        return count;
    }

    protected int computePageNo(int page) {
        return Pagination.computePageNumber(page, this.limit, this.totalCount);
    }

    public Integer[] getSlider() {
        return this.slider(5);
    }

    public Integer[] slider(int slidersCount) {
        return Pagination.generateLinkPageNumbers(this.getPage(), this.getTotalPages(), slidersCount);
    }

    private static int computeLastPageNumber(int totalItems, int pageSize) {
        int result;
        if (pageSize <= 0) {
            return 1;
        }
        int n = result = totalItems % pageSize == 0 ? totalItems / pageSize : totalItems / pageSize + 1;
        if (result <= 1) {
            result = 1;
        }
        return result;
    }

    private static int computePageNumber(int page, int pageSize, int totalItems) {
        if (page <= 1) {
            return 1;
        }
        if (Integer.MAX_VALUE == page || page > Pagination.computeLastPageNumber(totalItems, pageSize)) {
            return Pagination.computeLastPageNumber(totalItems, pageSize);
        }
        return page;
    }

    private static Integer[] generateLinkPageNumbers(int currentPageNumber, int lastPageNumber, int count) {
        int endPageNumber;
        int avg = count / 2;
        int startPageNumber = currentPageNumber - avg;
        if (startPageNumber <= 0) {
            startPageNumber = 1;
        }
        if ((endPageNumber = startPageNumber + count - 1) > lastPageNumber) {
            endPageNumber = lastPageNumber;
        }
        if (endPageNumber - startPageNumber < count && (startPageNumber = endPageNumber - count) <= 0) {
            startPageNumber = 1;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = startPageNumber; i <= endPageNumber; ++i) {
            result.add(new Integer(i));
        }
        return result.toArray(new Integer[result.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pagination");
        sb.append("{page=").append(this.page);
        sb.append(", limit=").append(this.limit);
        sb.append(", totalCount=").append(this.totalCount);
        sb.append('}');
        return sb.toString();
    }
}

