/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.core.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eispframework.web.system.pojo.base.TSUser;

public class Page
extends HashMap<String, String>
implements Serializable {
    public static String DEFAULT_PAGENAME = "ec";
    public static String DEFAULT_PAGESIZE = "15";
    public static String DEFAULT_EXPORTSIZE = "60000";
    public static String DEFAULT_PAGE = "1";
    public static String PAGE_NO = "page";
    public static String PAGE_SIZE = "rows";
    public static String TOTAL_COUNT = "total";
    public static String TOTAL_PAGE_COUNT = "totalPageCount";
    public static String HAS_NEXT_PAGE = "hasNextPage";
    public static String NEXT_PAGE = "nextPage";
    public static String HAS_PRE_PAGE = "hasPrePage";
    public static String PRE_PAGE = "prePage";
    public static String SORT = "sort";
    public static String DIR = "dir";
    public static String DEFAULT_SORT = "defaultSort";
    public static String USER_ID_KEY = "_userId";
    public static String EMP_ID_KEY = "_empId";
    public static String EMP_SUBCODE_KEY = "_empSubCode";
    public static String EMP_LEVELCODE_KEY = "_empLevelCode";
    public static String PARENT_EMP_ID_KEY = "_parentEmpId";
    public static String PARENT_EMP_SUBCODE_KEY = "_parentEmpSubCode";
    public static String PARENT_EMP_lEVELCODE_KEY = "_parentEmpLevelCode";
    public static String ORG_ID_KEY = "_orgId";
    public static String ORG_SUBCODE_KEY = "_orgSubCode";
    public static String ORG_LEVELCODE_KEY = "_orgLevelCode";
    public static String PARENT_ORG_ID_KEY = "_parentOrgId";
    public static String PARENT_ORG_SUBCODE_KEY = "_parentOrgSubCode";
    public static String PARENT_ORG_LEVELCODE_KEY = "_parentOrgLevelCode";
    public static String EMP_AUTH_KEY = "_empAuth";
    public static String EMP_CASCADE_AUTH_KEY = "_empCascadeAuth";
    public static String ORG_AUTH_KEY = "_orgAuth";
    public static String PROD_AUTH_KEY = "_prodAuth";
    public static String DATA_AUTH = "_dataAuth";
    public static String DATA_AUTH_LEVEL = "_dataAuthLevel";
    public static String BRANCH_RESOURCE_KEY = "_branchResource";
    public static String PARTNER_RESOURCE_KEY = "_partnerResource";
    public static String WAREHOUSE_RESOURCE_KEY = "_warehouseResource";
    public static String PRICE_DECIMAL = "priceDecimal";
    public static String PRICE_DECIMAL_PATTERN = "priceDecimalPattern";
    public static String QUANTITY_DECIMAL = "quantityDecimal";
    public static String QUANTITY_DECIMAL_PATTERN = "quantityDecimalPattern";
    public static String AMOUNT_DECIMAL = "amountDecimal";
    public static String AMOUNT_DECIMAL_PATTERN = "amountDecimalPattern";
    public static String AUTH_PREFIX = "_authPrefix";
    protected String pageName;
    protected boolean paging = true;

    public Page() {
        this.pageName = DEFAULT_PAGENAME;
        this.initParams();
    }

    public Page(HttpServletRequest request) {
        this(request, DEFAULT_PAGENAME);
    }

    public Page(HttpServletRequest request, String pageName) {
        this.pageName = pageName;
        this.initParams();
        this.initParams(request);
    }

    protected void initParams(HttpServletRequest request) {
        if ("1".equals(request.getParameter("first")) || "-1".equals(request.getParameter("first"))) {
            request.getSession().removeAttribute(this.pageName);
        }
        if (request.getSession().getAttribute(this.pageName) != null) {
            this.putAll((Map)request.getSession().getAttribute(this.pageName));
        } else {
            TSUser tSUser = (TSUser)request.getSession().getAttribute("user");
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            this.put(name, request.getParameter(name).replaceAll("'", "''"));
        }
        request.getSession().setAttribute(this.pageName, (Object)this);
    }

    protected void initParams() {
        this.put(PAGE_NO, DEFAULT_PAGE);
        this.put(PAGE_SIZE, DEFAULT_PAGESIZE);
    }

    public void compute() {
        int pageSize;
        int totalCount = this.getInt(TOTAL_COUNT);
        this.put(TOTAL_PAGE_COUNT, totalCount % (pageSize = this.getInt(PAGE_SIZE)) == 0 ? String.valueOf(totalCount / pageSize) : String.valueOf(totalCount / pageSize + 1));
    }

    public int getInt(String name) {
        return this.get(name) != null && !"".equals(this.get(name)) ? Integer.parseInt((String)this.get(name)) : 0;
    }

    public long getLong(String name) {
        return this.get(name) != null ? Long.parseLong((String)this.get(name)) : 0L;
    }

    public static void setValue(HttpServletRequest request, String pageName, String name, String value) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            page.put(name, value);
        }
    }

    public static void setValue(HttpServletRequest request, String name, String value) {
        Page.setValue(request, DEFAULT_PAGENAME, name, value);
    }

    public static String getValue(HttpServletRequest request, String pageName, String name) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            return (String)page.get(name);
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String name) {
        return Page.getValue(request, DEFAULT_PAGENAME, name);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }
}

