/*
 * Decompiled with CFR 0.152.
 */
package org.eispframework.core.util;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eispframework.core.util.ContextHolderUtils;
import org.eispframework.core.util.DBTypeUtil;
import org.eispframework.core.util.DateUtils;
import org.eispframework.core.util.LogUtil;
import org.eispframework.core.util.oConvertUtils;
import org.eispframework.web.system.manager.ClientManager;
import org.eispframework.web.system.pojo.base.TSRoleFunction;
import org.eispframework.web.system.pojo.base.TSUser;

public class ResourceUtil
implements Serializable {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("connection/sysConfig");

    public static final String getSessionattachmenttitle(String sessionName) {
        return bundle.getString(sessionName);
    }

    public static final TSUser getSessionUserName() {
        HttpSession session = ContextHolderUtils.getSession();
        if (ClientManager.getInstance().getClient(session.getId()) != null) {
            return ClientManager.getInstance().getClient(session.getId()).getUser();
        }
        return null;
    }

    @Deprecated
    public static final List<TSRoleFunction> getSessionTSRoleFunction(String roleId) {
        HttpSession session = ContextHolderUtils.getSession();
        if (session.getAttributeNames().hasMoreElements()) {
            List TSRoleFunctionList = (List)session.getAttribute(roleId);
            if (TSRoleFunctionList != null) {
                return TSRoleFunctionList;
            }
            return null;
        }
        return null;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        String s = request.getContextPath();
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static final String getConfigByName(String name) {
        return bundle.getString(name);
    }

    public static final Map<Object, Object> getConfigMap(String path) {
        ResourceBundle bundle = ResourceBundle.getBundle(path);
        Set<String> set = bundle.keySet();
        return oConvertUtils.SetToMap(set);
    }

    public static String getSysPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "").replaceFirst("WEB-INF/classes/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", separator + separator).replaceAll("%20", " ");
        return resultPath;
    }

    public static String getPorjectPath() {
        String nowpath = System.getProperty("user.dir");
        String tempdir = nowpath.replace("bin", "webapps");
        tempdir = tempdir + "\\";
        return tempdir;
    }

    public static String getClassPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", separator + separator);
        return resultPath;
    }

    public static String getSystempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static String getRandCodeLength() {
        return bundle.getString("randCodeLength");
    }

    public static String getRandCodeType() {
        return bundle.getString("randCodeType");
    }

    public static String getOrgCodeLengthType() {
        return bundle.getString("orgCodeLengthType");
    }

    public static String getOrgCodeDQ() {
        return bundle.getString("org_code");
    }

    public static String getProperValue(String p_code) {
        return bundle.getString(p_code);
    }

    public static String getUserSystemData(String key) {
        if (key.equals("sysUserCode") || key.equals("sys_user_code")) {
            return ResourceUtil.getSessionUserName().getUserName();
        }
        if (key.equals("sysUserName") || key.equals("sys_user_name")) {
            return ResourceUtil.getSessionUserName().getRealName();
        }
        if (key.equals("sysDate") || key.equals("sys_date")) {
            return DateUtils.formatDate();
        }
        if (key.equals("sysTime") || key.equals("sys_time")) {
            return DateUtils.formatTime();
        }
        return null;
    }

    public static String getServerIp(String ipstart) {
        String sysType = System.getProperties().getProperty("os.name");
        if (sysType.toLowerCase().startsWith("win")) {
            String localIP = null;
            try {
                localIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.getMessage();
            }
            if (localIP != null) {
                return localIP;
            }
        } else {
            String ip = ResourceUtil.getIpByEthNumStartAs("192.168");
            if (ip != null) {
                return ip;
            }
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    public static String getIpByEthNum(String ethNum) {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (!ethNum.equals(netInterface.getName())) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.getMessage();
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    public static String getIpByEthNumStartAs(String startip) {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || !ip.getHostAddress().startsWith(startip)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.getMessage();
        }
        return "\u83b7\u53d6\u670d\u52a1\u5668IP\u9519\u8bef";
    }

    public static void main(String[] args) {
        LogUtil.info((Object)ResourceUtil.getPorjectPath());
        LogUtil.info((Object)ResourceUtil.getSysPath());
    }
}

