/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.alibaba.dingtalk.local.service.impl;

import com.biz.crm.business.alibaba.dingtalk.sdk.constant.DingTalkConstant;
import com.biz.crm.business.alibaba.dingtalk.sdk.service.DingTalkService;
import com.biz.crm.business.common.auth.sdk.service.UrlApiService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.service.ExternalLogVoService;
import com.biz.crm.business.common.log.sdk.util.ExternalLogUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiV2UserGetbymobileRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiV2UserGetbymobileResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DingTalkServiceImpl
implements DingTalkService {
    private static final Logger log = LoggerFactory.getLogger(DingTalkServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private ExternalLogVoService externalLogVoService;
    @Autowired(required=false)
    private UrlApiService urlApiService;
    private UrlAddressVo urlAddressVo;

    public void init() {
        this.urlAddressVo = this.urlApiService.getUrlAddressByAccount("dingTalk");
        Assert.hasLength((String)this.urlAddressVo.getUrl(), (String)"\u9489\u9489\u63a5\u53e3URL\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)this.urlAddressVo.getAccessId(), (String)"\u9489\u9489\u53c2\u6570[agentId]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)this.urlAddressVo.getAccessKey(), (String)"\u9489\u9489\u53c2\u6570[appKey]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)this.urlAddressVo.getSecretKey(), (String)"\u9489\u9489\u53c2\u6570[appSecret]\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    public Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserId(String userId, String msgContent) {
        return this.sendTextMsg(userId, msgContent);
    }

    public Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserIdList(List<String> userIdList, String msgContent) {
        return this.sendTextMsg(StringUtils.join(userIdList, (String)","), msgContent);
    }

    private Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsg(String userIds, String msgContent) {
        Result<String> accessTokenResult = this.getDingTalkAccessToken();
        if (!accessTokenResult.isSuccess()) {
            return Result.error((String)accessTokenResult.getMessage());
        }
        Result result = new Result();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(this.urlAddressVo.getUrl() + "/topapi/message/corpconversation/asyncsend_v2");
            OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
            request.setAgentId(Long.valueOf(Long.parseLong(this.urlAddressVo.getAccessId())));
            request.setUseridList(userIds);
            request.setToAllUser(Boolean.valueOf(false));
            OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
            msg.setMsgtype("text");
            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
            msg.getText().setContent(msgContent);
            request.setMsg(msg);
            ExternalLogDetailDto detailDto = ExternalLogUtil.buildLogSaveInfo((Object)request, (UrlAddressVo)this.urlAddressVo);
            detailDto.setMethod("/topapi/message/corpconversation/asyncsend_v2");
            detailDto.setMethodMsg("\u53d1\u9001\u9489\u9489\u901a\u77e5\u6d88\u606f");
            this.externalLogVoService.addOrUpdateLog(detailDto, true);
            OapiMessageCorpconversationAsyncsendV2Response response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, (String)accessTokenResult.getResult());
            if (DingTalkConstant.SUCCESS_CODE.equals(response.getErrcode())) {
                result.setResult((Object)response);
                result.setMessage(response.getMsg());
            } else {
                result.setSuccess(false);
                result.setMessage(response.getSubMsg());
            }
            ExternalLogUtil.buildLogResult((ExternalLogDetailDto)detailDto, (Object)result);
            this.externalLogVoService.addOrUpdateLog(detailDto, false);
        }
        catch (ApiException e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public Result<String> getDingTalkAccessToken() {
        this.init();
        String token = (String)this.redisService.get("ding:talk:token");
        Result result = new Result();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            result.setResult((Object)token);
            return result;
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient(this.urlAddressVo.getUrl() + "/gettoken");
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey(this.urlAddressVo.getAccessKey());
        request.setAppsecret(this.urlAddressVo.getSecretKey());
        request.setHttpMethod("GET");
        try {
            OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            result.setMessage(response.getErrmsg());
            if (DingTalkConstant.SUCCESS_CODE.equals(response.getErrcode())) {
                result.setResult((Object)response.getAccessToken());
                if (Objects.nonNull(response.getExpiresIn()) && response.getExpiresIn() - 100L > 0L) {
                    this.redisService.set("ding:talk:token", (Object)response.getAccessToken(), response.getExpiresIn() - 100L);
                }
            } else {
                result.setSuccess(false);
                result.setMessage(response.getErrmsg());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setSuccess(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public String getUserIdByMobile(String mobile) {
        Assert.hasLength((String)mobile, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Result<String> result = this.getDingTalkAccessToken();
        Assert.isTrue((boolean)result.isSuccess(), (String)"\u83b7\u53d6\u9489\u9489Token\u5931\u8d25!");
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(this.urlAddressVo.getUrl() + "/topapi/v2/user/getbymobile");
            OapiV2UserGetbymobileRequest req = new OapiV2UserGetbymobileRequest();
            req.setMobile(mobile);
            OapiV2UserGetbymobileResponse rsp = (OapiV2UserGetbymobileResponse)client.execute((TaobaoRequest)req, (String)result.getResult());
            return rsp.getBody();
        }
        catch (ApiException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

