package com.biz.crm.business.alibaba.dingtalk.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.alibaba.dingtalk.sdk.service.DingTalkService;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 钉钉
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2022.12.3 12:02
 */
@Slf4j
@RestController
@RequestMapping("/v1/dingTalk")
@Api(tags = "钉钉: dingTalk", hidden = true)
public class DingTalkController {

    @Resource
    private DingTalkService dingTalkService;


    @ApiOperation(value = "根据钉钉用户ID/用户账号发送钉钉文本类型消息")
    @PostMapping(value = "/sendTextMsgByUserId")
    public Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserId(@RequestParam(value = "userId") String userId,
                                                                                      @RequestParam(value = "msgContent") String msgContent) {
        try {
            return dingTalkService.sendTextMsgByUserId(userId, msgContent);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据钉钉用户ID/用户账号集合批量发送钉钉文本类型消息")
    @PostMapping(value = "/sendTextMsgByUserIdList")
    public Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserIdList(@RequestBody List<String> userIdList,
                                                                                          @RequestParam(value = "msgContent") String msgContent) {
        try {
            return dingTalkService.sendTextMsgByUserIdList(userIdList, msgContent);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "获取钉钉AccessToken")
    @GetMapping(value = "/getDingTalkAccessToken")
    public Result<String> getDingTalkAccessToken() {
        try {
            return dingTalkService.getDingTalkAccessToken();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "根据手机号获取userId")
    @GetMapping(value = "/getUserIdByMobile")
    public Result<String> getUserIdByMobile(@RequestParam(value = "mobile") String mobile) {
        try {
            Result<String> result = new Result<>();
            String userId = dingTalkService.getUserIdByMobile(mobile);
            result.setResult(userId);
            return result;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
