package com.biz.crm.business.alibaba.dingtalk.sdk.vo;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 发送钉钉消息
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2022.11.23 17:51
 */
@Data
public class DingTalkDto implements Serializable {

    private static final long serialVersionUID = -7694497199108463778L;

    @ApiModelProperty(name = "messageId", notes = "发送消息时使用的微应用的AgentID。")
    @JsonProperty("agent_id")
    private Long agentId;

    @ApiModelProperty(name = "userIdList", notes = "接收者的userid列表，最大用户列表长度100。")
    @JsonProperty("userid_list")
    private List<String> userIdList;

    @ApiModelProperty(name = "deptIdList", notes = "接收者是部门ID时，包括子部门下的所有用户。")
    @JsonProperty("dept_id_list")
    private List<String> deptIdList;

    @ApiModelProperty(name = "toAllUser", notes = "接收者是部门ID时，包括子部门下的所有用户。")
    @JsonProperty("to_all_user")
    private String toAllUser;

    @ApiModelProperty(name = "toAllUser", notes = "接收者是部门ID时，包括子部门下的所有用户。")
    @JsonProperty("to_all_user")
    private JSONObject msg;

}
