/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.feign.service.internal;

import com.biz.crm.business.common.auth.sdk.eunm.BusinessKeyEnum;
import com.biz.crm.business.common.auth.sdk.exception.SignException;
import com.biz.crm.business.common.auth.sdk.service.AuthSignService;
import com.biz.crm.business.common.auth.sdk.service.UrlApiService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuthSignServiceImpl
implements AuthSignService {
    private static final Logger log = LoggerFactory.getLogger(AuthSignServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private UrlApiService urlApiService;

    public UrlAddressVo getSignInfoForAccessKey(String accessKey) {
        Assert.hasLength((String)accessKey, (String)"\u53c2\u6570[ak]\u4e0d\u80fd\u4e3a\u7a7a!");
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccessKey(accessKey);
        Assert.hasLength((String)urlAddressVo.getSecretKey(), (String)"\u5bc6\u5319\u672a\u914d\u7f6e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        long accessTimesMax = urlAddressVo.getAccessTimesMax().intValue();
        String redisKey = "external:access_limit_lock:" + accessKey;
        long accessTimes = this.redisService.hIncr(redisKey, urlAddressVo.getAccessKey(), Long.valueOf(1L));
        long expireDate = this.redisService.getExpire(redisKey);
        if (expireDate <= 0L) {
            this.redisService.expire(redisKey, 20L);
        }
        Assert.isTrue((accessTimes < accessTimesMax ? 1 : 0) != 0, (String)("[" + SignException.ACCESS_LIMIT.getCode() + "]" + SignException.ACCESS_LIMIT.getDescription()));
        return urlAddressVo;
    }

    public void valAuthority(UrlAddressVo urlAddressVo, Map<String, Object> dataMap) {
        Assert.notNull((Object)urlAddressVo, (String)("[" + SignException.NO_PERMISSION.getCode() + "]" + SignException.NO_PERMISSION.getDescription()));
        Assert.notEmpty(dataMap, (String)("[" + SignException.NOT_NULL.getCode() + "]" + SignException.NOT_NULL.getDescription()));
        if (BooleanEnum.TRUE.getCapital().equals(urlAddressVo.getIsAll())) {
            return;
        }
        Map authorityMap = urlAddressVo.getAuthorityMap();
        Assert.notEmpty((Map)authorityMap, (String)(SignException.NO_PERMISSION.getDescription() + "[" + SignException.NO_PERMISSION.getCode() + "]"));
        List businessInterfaceList = authorityMap.getOrDefault(BusinessKeyEnum.BUSINESS_INTERFACE.getCode(), Lists.newArrayList());
        Assert.notEmpty((Collection)businessInterfaceList, (String)("[" + SignException.NO_PERMISSION.getCode() + "]" + SignException.NO_PERMISSION.getDescription()));
        String requestUri = (String)dataMap.get("REQUEST_URI_MAP_KEY");
        Assert.isTrue((boolean)businessInterfaceList.contains(requestUri), (String)("[" + SignException.NO_PERMISSION.getCode() + "]" + SignException.NO_PERMISSION.getDescription()));
    }

    public Boolean verifySignExpired(Integer signExpireDate, String timestamp) {
        if (Objects.isNull(signExpireDate) || StringUtils.isEmpty((CharSequence)timestamp)) {
            return false;
        }
        long timestampLong = 0L;
        try {
            timestampLong = Long.parseLong(timestamp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return timestampLong + (long)signExpireDate.intValue() * 60L * 1000L >= System.currentTimeMillis();
    }

    public String parameterBodySort(Map<String, Object> parameterMap) {
        String result = "";
        try {
            ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(parameterMap.entrySet());
            infoIds.sort(Map.Entry.comparingByKey());
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getKey()))) continue;
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val == null || val == "") continue;
                stringBuilder.append(key).append("=").append(val).append("&");
            }
            result = stringBuilder.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public String parameterBodySign(Map<String, Object> parameterMap) {
        Assert.notEmpty(parameterMap, (String)"\u7b7e\u540d\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            String sortEnd = this.parameterBodySort(parameterMap);
            return DigestUtils.md5Hex((String)sortEnd);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public String parameterHeaderSign(String timestamp, String accessKey, String secretKey) {
        Assert.hasLength((String)timestamp, (String)"\u53c2\u6570[timestamp]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)accessKey, (String)"\u53c2\u6570[ak]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)secretKey, (String)"\u53c2\u6570[sk]\u4e0d\u80fd\u4e3a\u7a7a!");
        String signStr = timestamp + accessKey + secretKey;
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] digest = md5.digest(signStr.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }
}

