package com.biz.crm.business.common.auth.feign.feign;

import com.biz.crm.business.common.auth.feign.feign.internal.UrlAddressVoFeignImpl;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 外部系统配置信息 feign
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.15 12:39
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = UrlAddressVoFeignImpl.class)
public interface UrlAddressVoFeign {

    /**
     * 根据账号获取详情
     *
     * @param account 账号
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo>
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.15 12:45
     */
    @ApiOperation(value = "根据id详情")
    @GetMapping("/v1/urlAddress/urlAddressVo/getUrlAddressByAccount")
    Result<UrlAddressVo> getUrlAddressByAccount(@RequestParam("account") String account);


    /**
     * 根据密匙获取详情
     *
     * @param accessKey 密匙
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo>
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.15 12:45
     */
    @ApiOperation(value = "根据编码查询详情")
    @GetMapping("/v1/urlAddress/urlAddressVo/getUrlAddressByAccessKey")
    Result<UrlAddressVo> getUrlAddressByAccessKey(@RequestParam("accessKey") String accessKey);

}
