package com.biz.crm.business.common.auth.feign.service.internal;

import com.biz.crm.business.common.auth.sdk.service.CryptorStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

/**
 * body参数加密
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024/6/6 13:55
 */
@Service
@Slf4j
public class CryptorStrategyImpl implements CryptorStrategy {

    private static final String RSA = "rsa";

    /**
     * 加密
     *
     * @param key
     * @param data
     * @return java.lang.String
     * @author huxmld
     * @version v1.0.0
     * @date 2024/6/6 13:56
     */
    @Override
    public String encrypt(String key, String data) {
        byte[] decoded = Base64.getDecoder().decode(key);
        try {
            RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(Cipher.ENCRYPT_MODE, pubKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }


    /**
     * 解密
     *
     * @param key
     * @param encryptData
     * @return java.lang.String
     * @author huxmld
     * @version v1.0.0
     * @date 2024/6/6 13:56
     */
    @Override
    public String decrypt(String key, byte[] encryptData) {
        byte[] decoded = Base64.getDecoder().decode(key);
        try {

            PrivateKey priKey = KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(Cipher.DECRYPT_MODE, priKey);
            return new String(cipher.doFinal(encryptData));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }
}
