package com.biz.crm.business.common.auth.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.auth.feign.feign.UrlAddressVoFeign;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 外部系统配置信息 feign接口熔断类
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2022.11.5 13:59
 */
@Component
public class UrlAddressVoFeignImpl implements FallbackFactory<UrlAddressVoFeign> {
    @Override
    public UrlAddressVoFeign create(Throwable throwable) {
        return new UrlAddressVoFeign() {

            @Override
            public Result<UrlAddressVo> getUrlAddressByAccount(String account) {
                throw new UnsupportedOperationException("根据账号查询详情熔断");
            }

            @Override
            public Result<UrlAddressVo> getUrlAddressByAccessKey(String accessKey) {
                throw new UnsupportedOperationException("根据账号查询密匙熔断");
            }

        };
    }
}
