/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.feign.service.internal;

import com.biz.crm.business.common.auth.sdk.service.CryptorStrategy;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CryptorStrategyImpl
implements CryptorStrategy {
    private static final Logger log = LoggerFactory.getLogger(CryptorStrategyImpl.class);
    private static final String RSA = "rsa";

    public String encrypt(String key, String data) {
        byte[] decoded = Base64.getDecoder().decode(key);
        try {
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance(RSA).generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(1, pubKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String decrypt(String key, byte[] encryptData) {
        byte[] decoded = Base64.getDecoder().decode(key);
        try {
            PrivateKey priKey = KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance(RSA);
            cipher.init(2, priKey);
            return new String(cipher.doFinal(encryptData));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

