/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.feign.service.internal;

import com.biz.crm.business.common.auth.feign.feign.UrlAddressVoFeign;
import com.biz.crm.business.common.auth.sdk.constans.AuthConstant;
import com.biz.crm.business.common.auth.sdk.service.UrlApiService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.model.Result;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UrlApiServiceImpl
implements UrlApiService {
    private static final Logger log = LoggerFactory.getLogger(UrlApiServiceImpl.class);
    @Autowired(required=false)
    private UrlAddressVoFeign urlAddressVoFeign;
    private static volatile Cache<String, UrlAddressVo> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UrlApiServiceImpl() {
        if (cache != null) return;
        Class<UrlApiServiceImpl> clazz = UrlApiServiceImpl.class;
        synchronized (UrlApiServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite((long)AuthConstant.CACHE_TIME.intValue(), TimeUnit.MINUTES).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public UrlAddressVo getUrlAddressByAccount(String account) {
        Assert.hasLength((String)account, (String)"\u53c2\u6570[account]\u4e0d\u80fd\u4e3a\u7a7a!");
        UrlAddressVo urlAddressVo = (UrlAddressVo)cache.getIfPresent((Object)account);
        if (Objects.nonNull(urlAddressVo)) {
            return urlAddressVo;
        }
        Result<UrlAddressVo> result = this.urlAddressVoFeign.getUrlAddressByAccount(account);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        if (Objects.nonNull(result.getResult())) {
            cache.put((Object)account, result.getResult());
        }
        return (UrlAddressVo)result.getResult();
    }

    public UrlAddressVo getUrlAddressByAccessKey(String accessKey) {
        Assert.hasLength((String)accessKey, (String)"\u53c2\u6570[ak]\u4e0d\u80fd\u4e3a\u7a7a!");
        UrlAddressVo urlAddressVo = (UrlAddressVo)cache.getIfPresent((Object)accessKey);
        if (Objects.nonNull(urlAddressVo)) {
            return urlAddressVo;
        }
        Result<UrlAddressVo> result = this.urlAddressVoFeign.getUrlAddressByAccessKey(accessKey);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        if (Objects.nonNull(result.getResult())) {
            cache.put((Object)accessKey, result.getResult());
        }
        return (UrlAddressVo)result.getResult();
    }

    public String getUserNameByAccessKey(String accessKey) {
        return this.getUrlAddressByAccessKey(accessKey).getUserName();
    }
}

