/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.auth.sdk.constans.AuthConstant;
import com.biz.crm.business.common.auth.sdk.dto.SignBaseDto;
import com.biz.crm.business.common.auth.sdk.service.AuthSignService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.business.common.log.sdk.constant.ExternalLogGlobalConstants;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.service.ExternalLogVoService;
import com.biz.crm.business.common.log.sdk.util.ExternalLogUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SignBodyAspect {
    private static final Logger log = LoggerFactory.getLogger(SignBodyAspect.class);
    protected static final ThreadLocal<ConcurrentHashMap<Long, ExternalLogDetailDto>> LOG_VO_MAP = new ThreadLocal();
    @Autowired(required=false)
    private AuthSignService authSignService;
    @Autowired(required=false)
    private ExternalLogVoService externalLogVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Before(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignBody) || @within(com.biz.crm.business.common.auth.sdk.aop.SignBodyGlobal)")
    public void doBefore(JoinPoint joinPoint) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            Assert.notNull((Object)requestAttributes, (String)"\u8bf7\u6c42\u4e0d\u5408\u6cd5!");
            HttpServletRequest request = requestAttributes.getRequest();
            String requestMethod = request.getMethod();
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String paraName = (String)headerNames.nextElement();
                String paraValue = request.getHeader(paraName);
                headMap.put(paraName, paraValue);
            }
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                Enumeration enu = request.getParameterNames();
                while (enu.hasMoreElements()) {
                    String paraName = (String)enu.nextElement();
                    String paraValue = request.getParameter(paraName);
                    dataMap.put(paraName, paraValue);
                }
            } else {
                Optional.ofNullable(joinPoint.getArgs()).ifPresent(x -> {
                    for (Object o : x) {
                        if (o instanceof JSONObject) {
                            dataMap.putAll(((JSONObject)o).getInnerMap());
                            continue;
                        }
                        dataMap.putAll((Map<String, String>)BeanMap.create((Object)o));
                    }
                });
            }
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            String reqBody = JSON.toJSONString(dataMap);
            String timestamp = request.getHeader("timestamp");
            String accessKey = request.getHeader("accessKey");
            String token = request.getHeader("token");
            SignBaseDto dto = (SignBaseDto)JSON.parseObject((String)reqBody, SignBaseDto.class);
            if (dto == null) {
                dto = new SignBaseDto();
            }
            ExternalLogDetailDto detailDto = ExternalLogUtil.buildLogSaveInfo((Object)dto);
            detailDto.setReqHead(JSON.toJSONString(headMap));
            detailDto.setReqJson(reqBody);
            detailDto.setAccessKey(accessKey);
            detailDto.setMethod(StringUtils.stripToEmpty((String)method.getName()));
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            Optional.ofNullable(apiOperation).filter(x -> !StringUtils.isEmpty((CharSequence)x.value())).ifPresent(x -> detailDto.setMethodMsg(x.value()));
            detailDto.setInvokeType(ExternalLogGlobalConstants.EXTERNAL_INTERFACE);
            this.addLogVo(detailDto);
            this.loginUserService.refreshAuthentication(null);
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, true);
            } else {
                log.info("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
            UrlAddressVo urlAddressVo = this.authSignService.getSignInfoForAccessKey(accessKey);
            this.authSignService.valAuthority(urlAddressVo, dataMap);
            this.loginUserService.refreshAuthentication((Object)urlAddressVo);
            detailDto.setUserName(urlAddressVo.getUserName());
            detailDto.setFullName(urlAddressVo.getFullName());
            this.addLogVo(detailDto);
            Assert.hasLength((String)token, (String)"\u53c2\u6570[token]\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)timestamp, (String)"\u53c2\u6570[timestamp]\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)accessKey, (String)"\u53c2\u6570[accessKey]\u4e0d\u80fd\u4e3a\u7a7a!");
            this.valBaseInfoEmpty(dto);
            Assert.isTrue((boolean)this.authSignService.verifySignExpired(urlAddressVo.getSignExpireDate(), timestamp), (String)"\u7b7e\u540d\u5df2\u8fc7\u671f!");
            dataMap.put(accessKey, urlAddressVo.getAccessKey() + urlAddressVo.getSecretKey());
            dataMap.put("timestamp", timestamp);
            String parameterSign = this.authSignService.parameterBodySign(dataMap);
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)parameterSign, (CharSequence)token), (String)"\u7b7e\u540d\u672a\u901a\u8fc7!");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ExternalLogDetailDto detailDto = this.getLogVo();
            if (Objects.nonNull(detailDto)) {
                detailDto.setExceptionStack(ExceptionStackMsgUtil.stackMsg((Exception)e));
                detailDto.setTipMsg(e.getMessage());
                if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                    this.externalLogVoService.addOrUpdateLog(detailDto, false);
                } else {
                    log.error("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
                }
            }
            throw e;
        }
    }

    @AfterReturning(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignBody) || @within(com.biz.crm.business.common.auth.sdk.aop.SignBodyGlobal)", returning="result")
    public void AfterReturning(Object result) {
        ExternalLogDetailDto detailDto = this.getLogVo();
        if (Objects.nonNull(detailDto)) {
            ExternalLogUtil.buildLogResult((ExternalLogDetailDto)detailDto, (Object)result);
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, false);
            } else {
                log.info("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
        }
    }

    @AfterThrowing(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignBody) || @within(com.biz.crm.business.common.auth.sdk.aop.SignBodyGlobal)", throwing="e")
    public void AfterThrowing(Exception e) {
        ExternalLogDetailDto detailDto = this.getLogVo();
        if (Objects.nonNull(detailDto)) {
            detailDto.setExceptionStack(ExceptionStackMsgUtil.stackMsg((Exception)e));
            detailDto.setTipMsg(e.getMessage());
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, false);
            } else {
                log.error("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
        }
        log.error("======> AOP\u7b7e\u540d\u9a8c\u8bc1\u4fe1\u606f \u5f02\u5e38\u4fe1\u606f {} <======", (Object)e.getMessage());
        log.error("", (Throwable)e);
    }

    private void addLogVo(ExternalLogDetailDto respVo) {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<Long, Object> logMap = LOG_VO_MAP.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        logMap.put(thread.getId(), respVo);
        LOG_VO_MAP.set(logMap);
    }

    private ExternalLogDetailDto getLogVo() {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<Long, Object> logMap = LOG_VO_MAP.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        ExternalLogDetailDto detailDto = logMap.get(thread.getId());
        logMap.remove(thread.getId());
        LOG_VO_MAP.set(logMap);
        return detailDto;
    }

    private void valBaseInfoEmpty(SignBaseDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getMethod(), (String)"\u53c2\u6570[method]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getUuid(), (String)"\u53c2\u6570[uuid]\u4e0d\u80fd\u4e3a\u7a7a!");
    }
}

