/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.controller;

import com.biz.crm.business.common.auth.local.dto.TestSignDtoSign;
import com.biz.crm.business.common.auth.sdk.aop.SignBody;
import com.biz.crm.business.common.auth.sdk.aop.SignHeader;
import com.biz.crm.business.common.auth.sdk.service.AuthSignService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auth/authSign"})
@Api(tags={"\u7b7e\u540d\u9a8c\u8bc1: authSign"}, hidden=true)
public class AuthSignController {
    private static final Logger log = LoggerFactory.getLogger(AuthSignController.class);
    @Resource
    private AuthSignService validateService;

    @ApiOperation(value="\u53c2\u6570\u6392\u5e8f\u9a8c\u8bc1")
    @PostMapping(value={"/parameterBodySort"})
    public Result parameterBodySort(@RequestBody Map<String, Object> parameterMap) {
        try {
            return Result.ok((String)this.validateService.parameterBodySort(parameterMap));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u53c2\u6570\u6392\u5e8f\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u53c2\u6570\u7b7e\u540d")
    @PostMapping(value={"/parameterBodySign"})
    public Result parameterBodySign(@RequestBody Map<String, Object> parameterMap) {
        try {
            Object accessKeyObj = parameterMap.getOrDefault("accessKey", "");
            if (Objects.isNull(accessKeyObj)) {
                return Result.error((String)"\u65e0accessKey\u4fe1\u606f!");
            }
            String accessKey = accessKeyObj.toString();
            Result result = new Result();
            parameterMap.remove("accessKey");
            UrlAddressVo urlAddressVo = this.validateService.getSignInfoForAccessKey(accessKey);
            parameterMap.put(accessKey, urlAddressVo.getAccessKey() + urlAddressVo.getSecretKey());
            String signToken = this.validateService.parameterBodySign(parameterMap);
            result.setResult((Object)signToken);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u53c2\u6570\u7b7e\u540d\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="Body\u7b7e\u540d\u7c7b\u578b:\u53c2\u6570\u9a8c\u8bc1")
    @PostMapping(value={"/bodySignVerify"})
    @SignBody
    public Result bodySignVerify(@RequestBody TestSignDtoSign signDto) {
        try {
            return Result.ok((String)"\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="Header\u7b7e\u540d\u7c7b\u578b:\u53c2\u6570\u9a8c\u8bc1")
    @PostMapping(value={"/headerSignVerify"})
    @SignHeader
    public Result headerSignVerify(@RequestBody TestSignDtoSign signDto) {
        try {
            return Result.ok((String)"\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7!");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
        }
    }
}

