/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.local.entity.UrlAddressAuthority;
import com.biz.crm.business.common.auth.local.repository.UrlAddressAuthorityRepository;
import com.biz.crm.business.common.auth.local.repository.UrlAddressRepository;
import com.biz.crm.business.common.auth.local.service.UrlAddressService;
import com.biz.crm.business.common.auth.sdk.eunm.BusinessKeyEnum;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class UrlAddressServiceImpl
implements UrlAddressService {
    private static final Logger log = LoggerFactory.getLogger(UrlAddressServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UrlAddressRepository urlAddressRepository;
    @Autowired(required=false)
    private UrlAddressAuthorityRepository urlAddressAuthorityRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(UrlAddress dto) {
        UrlAddress urlAddress = this.valBaseInfo(dto);
        this.valSave(urlAddress);
        this.saveAuthorityList(dto.getAuthorityMap(), dto.getUserName());
        this.urlAddressRepository.save((Object)urlAddress);
    }

    private void valSave(UrlAddress urlAddress) {
        int countAccessKey = ((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getAccessKey, (Object)urlAddress.getAccessKey())).count();
        Assert.isTrue((countAccessKey < 1 ? 1 : 0) != 0, (String)("ak[" + urlAddress.getAccessKey() + "]\u5df2\u5b58\u5728"));
        int countUserName = ((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getUserName, (Object)urlAddress.getUserName())).count();
        Assert.isTrue((countUserName < 1 ? 1 : 0) != 0, (String)("\u8d26\u53f7[" + urlAddress.getUserName() + "]\u5df2\u5b58\u5728"));
        urlAddress.setTenantCode(TenantUtils.getTenantCode());
    }

    private void saveAuthorityList(Map<String, List<String>> authorityMap, String userName) {
        if (CollectionUtil.isEmpty(authorityMap)) {
            return;
        }
        this.urlAddressAuthorityRepository.delByUserName(userName);
        ArrayList authorityList = Lists.newArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        authorityMap.forEach((businessKey, list) -> list.forEach(businessCode -> {
            UrlAddressAuthority addressAuthority = new UrlAddressAuthority();
            addressAuthority.setUserName(userName);
            addressAuthority.setBusinessKey((String)businessKey);
            addressAuthority.setBusinessCode((String)businessCode);
            addressAuthority.setTenantCode(tenantCode);
            addressAuthority.setDelFlag(delFlag);
            addressAuthority.setEnableStatus(enableCode);
            authorityList.add(addressAuthority);
        }));
        if (CollectionUtil.isNotEmpty((Collection)authorityList)) {
            this.urlAddressAuthorityRepository.saveBatch(authorityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(UrlAddress dto) {
        UrlAddress urlAddress = this.valBaseInfo(dto);
        this.valUpdate(urlAddress);
        this.saveAuthorityList(dto.getAuthorityMap(), dto.getUserName());
        this.urlAddressRepository.updateById((Object)urlAddress);
    }

    private void valUpdate(UrlAddress urlAddress) {
        Assert.hasLength((String)urlAddress.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
        UrlAddress oldEntity = (UrlAddress)((Object)this.urlAddressRepository.getById((Serializable)((Object)urlAddress.getId())));
        Assert.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        int countAccessKey = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getAccessKey, (Object)urlAddress.getAccessKey())).ne(UuidEntity::getId, (Object)urlAddress.getId())).count();
        Assert.isTrue((countAccessKey < 1 ? 1 : 0) != 0, (String)("ak[" + urlAddress.getAccessKey() + "]\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539!"));
        int countUserName = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getUserName, (Object)urlAddress.getUserName())).ne(UuidEntity::getId, (Object)urlAddress.getId())).count();
        Assert.isTrue((countUserName < 1 ? 1 : 0) != 0, (String)("\u8d26\u53f7[" + urlAddress.getUserName() + "]\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539!"));
        this.urlAddressAuthorityRepository.delByUserName(oldEntity.getUserName());
        ArrayList delKeyList = Lists.newArrayList();
        delKeyList.add(this.getRedisKey(oldEntity.getAccessKey()));
        delKeyList.add(this.getRedisKey(oldEntity.getUserName()));
        this.redisService.del((List)delKeyList);
    }

    private UrlAddress valBaseInfo(UrlAddress dto) {
        Assert.notNull((Object)((Object)dto), (String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getUserName(), (String)"\u8d26\u53f7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getUrl(), (String)"URL\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getAccessKey(), (String)"ak\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getSecretKey(), (String)"sk\u4e0d\u80fd\u4e3a\u7a7a!");
        String isAll = dto.getIsAll();
        Assert.hasLength((String)dto.getIsAll(), (String)"\u662f\u5426\u6240\u6709\u63a5\u53e3\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a!");
        if (!BooleanEnum.TRUE.getCapital().equals(isAll) && !BooleanEnum.FALSE.getCapital().equals(isAll)) {
            throw new IllegalArgumentException("isAll\u4e0d\u5408\u6cd5,\u5fc5\u987b\u4e3a[Y/N]");
        }
        if (BooleanEnum.FALSE.getCapital().equals(isAll)) {
            Assert.notEmpty(dto.getAuthorityMap(), (String)"\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        } else {
            dto.setAuthorityMap(Maps.newHashMap());
        }
        if (CollectionUtil.isNotEmpty(dto.getAuthorityMap())) {
            dto.getAuthorityMap().forEach((businessKey, list) -> {
                BusinessKeyEnum businessKeyEnum = BusinessKeyEnum.codeToEnum((String)businessKey);
                Assert.notNull((Object)businessKeyEnum, (String)("\u6743\u9650\u7c7b\u578b[" + businessKey + "]\u4e0d\u5408\u6cd5!"));
                Assert.notEmpty((Collection)list, (String)"\u6743\u9650\u7c7b\u578b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
                switch (businessKeyEnum) {
                    case BUSINESS_INTERFACE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u6b64\u7c7b\u578b\u672a\u5b9a\u4e49!");
                    }
                }
            });
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateDelFlagByIds(ids);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    public UrlAddressVo findById(String id) {
        UrlAddress urlAddress = this.urlAddressRepository.findById(id);
        if (Objects.isNull((Object)urlAddress)) {
            return null;
        }
        UrlAddressVo urlAddressVo = (UrlAddressVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)urlAddress, UrlAddressVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<UrlAddressAuthority> urlAddressAuthorityList = this.urlAddressAuthorityRepository.getByUserName(urlAddressVo.getUserName());
        if (CollectionUtil.isEmpty(urlAddressAuthorityList)) {
            return urlAddressVo;
        }
        Map authorityMap = urlAddressAuthorityList.stream().collect(Collectors.groupingBy(UrlAddressAuthority::getBusinessKey, Collectors.mapping(UrlAddressAuthority::getBusinessCode, Collectors.toList())));
        urlAddressVo.setAuthorityMap(authorityMap);
        return urlAddressVo;
    }

    @Override
    public String getRedisKey(String key) {
        Assert.hasLength((String)key, (String)"redis key must not null!");
        return "external:cache:" + key;
    }
}

