/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.local.entity.UrlAddressAuthority;
import com.biz.crm.business.common.auth.local.repository.UrlAddressAuthorityRepository;
import com.biz.crm.business.common.auth.local.repository.UrlAddressRepository;
import com.biz.crm.business.common.auth.local.service.UrlAddressService;
import com.biz.crm.business.common.auth.sdk.constans.AuthConstant;
import com.biz.crm.business.common.auth.sdk.service.UrlApiService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UrlApiServiceImpl
implements UrlApiService {
    private static final Logger log = LoggerFactory.getLogger(UrlApiServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UrlAddressRepository urlAddressRepository;
    @Autowired(required=false)
    private UrlAddressAuthorityRepository urlAddressAuthorityRepository;
    @Autowired(required=false)
    private UrlAddressService urlAddressService;
    private static final String URL_TAIL = "/";
    private static volatile Cache<String, UrlAddressVo> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UrlApiServiceImpl() {
        if (cache != null) return;
        Class<UrlApiServiceImpl> clazz = UrlApiServiceImpl.class;
        synchronized (UrlApiServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite((long)AuthConstant.CACHE_TIME_MINUTES.intValue(), TimeUnit.MINUTES).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public UrlAddressVo getUrlAddressByAccount(String account) {
        Assert.hasLength((String)account, (String)"account\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        String redisKey = this.urlAddressService.getRedisKey(account);
        UrlAddressVo urlAddressVo = (UrlAddressVo)cache.getIfPresent((Object)account);
        if (Objects.isNull(urlAddressVo) && Objects.nonNull(urlAddressVo = (UrlAddressVo)this.redisService.get(redisKey))) {
            cache.put((Object)account, (Object)urlAddressVo);
        }
        if (Objects.isNull(urlAddressVo)) {
            UrlAddress urlAddress = this.urlAddressRepository.getUrlAddressByAccount(account);
            if (Objects.isNull((Object)urlAddress)) {
                urlAddressVo = new UrlAddressVo();
                urlAddressVo.setUserName(account);
            }
            urlAddressVo = this.buildUrlVo(urlAddress);
            this.redisService.set(redisKey, (Object)urlAddressVo, 60L * (long)urlAddressVo.getCacheTime().intValue());
        }
        this.urlVerification(urlAddressVo);
        return urlAddressVo;
    }

    public UrlAddressVo getUrlAddressByAccessKey(String accessKey) {
        Assert.hasLength((String)accessKey, (String)"accessKey\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        String redisKey = this.urlAddressService.getRedisKey(accessKey);
        UrlAddressVo urlAddressVo = (UrlAddressVo)cache.getIfPresent((Object)accessKey);
        if (Objects.isNull(urlAddressVo) && Objects.nonNull(urlAddressVo = (UrlAddressVo)this.redisService.get(redisKey))) {
            cache.put((Object)accessKey, (Object)urlAddressVo);
        }
        if (Objects.isNull(urlAddressVo)) {
            UrlAddress urlAddress = this.urlAddressRepository.getUrlAddressByAccessKey(accessKey);
            if (Objects.isNull((Object)urlAddress)) {
                urlAddressVo = new UrlAddressVo();
                urlAddressVo.setAccessKey(accessKey);
            }
            urlAddressVo = this.buildUrlVo(urlAddress);
            this.redisService.set(redisKey, (Object)urlAddressVo, 60L * (long)urlAddressVo.getCacheTime().intValue());
        }
        this.urlVerification(urlAddressVo);
        return urlAddressVo;
    }

    public String getUserNameByAccessKey(String accessKey) {
        return this.getUrlAddressByAccessKey(accessKey).getUserName();
    }

    private void urlVerification(UrlAddressVo urlAddressVo) {
        String mobileUrl;
        Assert.notNull((Object)urlAddressVo, (String)"\u65e0\u5f53\u524d\u7528\u6237\u4fe1\u606f,\u8bbf\u95ee\u5931\u8d25!");
        Assert.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(urlAddressVo.getEnableStatus()), (String)("\u5f53\u524dak[" + urlAddressVo.getAccessKey() + "]\u5df2\u88ab\u7981\u7528,\u8bbf\u95ee\u5931\u8d25!"));
        Assert.hasLength((String)urlAddressVo.getAccessKey(), (String)("\u5f53\u524dak[" + urlAddressVo.getAccessKey() + "]\u672a\u914d\u7f6eaccessKey\u4fe1\u606f!"));
        Assert.hasLength((String)urlAddressVo.getUserName(), (String)("\u5f53\u524dak[" + urlAddressVo.getAccessKey() + "]\u672a\u914d\u7f6e\u8d26\u53f7\u4fe1\u606f!"));
        Assert.hasLength((String)urlAddressVo.getUrl(), (String)("\u5f53\u524dak[" + urlAddressVo.getAccessKey() + "]\u672a\u914d\u7f6eURL\u4fe1\u606f,\u8bbf\u95ee\u5931\u8d25!"));
        String url = urlAddressVo.getUrl();
        if (url.endsWith(URL_TAIL)) {
            urlAddressVo.setUrl(url.substring(0, url.length() - 1));
        }
        if (StringUtil.isNotEmpty((CharSequence)(mobileUrl = urlAddressVo.getMobileUrl())) && mobileUrl.endsWith(URL_TAIL)) {
            urlAddressVo.setMobileUrl(mobileUrl.substring(0, url.length() - 1));
        }
        Assert.hasLength((String)urlAddressVo.getSecretKey(), (String)("\u5f53\u524dak[" + urlAddressVo.getAccessKey() + "]\u672a\u914d\u7f6esecretKey\u4fe1\u606f!"));
        List<UrlAddressAuthority> urlAddressAuthorityList = this.urlAddressAuthorityRepository.getByUserName(urlAddressVo.getUserName());
        if (CollectionUtil.isEmpty(urlAddressAuthorityList)) {
            return;
        }
        Map authorityMap = urlAddressAuthorityList.stream().collect(Collectors.groupingBy(UrlAddressAuthority::getBusinessKey, Collectors.mapping(UrlAddressAuthority::getBusinessCode, Collectors.toList())));
        urlAddressVo.setAuthorityMap(authorityMap);
    }

    private UrlAddressVo buildUrlVo(UrlAddress urlAddress) {
        Assert.notNull((Object)((Object)urlAddress), (String)"\u65e0\u5f53\u524d\u7528\u6237\u4fe1\u606f,\u8bbf\u95ee\u5931\u8d25!");
        UrlAddressVo urlAddressVo = (UrlAddressVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)urlAddress, UrlAddressVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (Objects.isNull(urlAddressVo.getCacheTime())) {
            urlAddressVo.setCacheTime(AuthConstant.DEFAULT_CACHE_TIME);
        }
        if (Objects.isNull(urlAddressVo.getSignExpireDate())) {
            urlAddressVo.setSignExpireDate(AuthConstant.DEFAULT_SIGN_EXPIRE_DATE);
        }
        if (Objects.isNull(urlAddressVo.getAccessTimesMax())) {
            urlAddressVo.setAccessTimesMax(AuthConstant.DEFAULT_ACCESS_TIMES_MAX);
        }
        urlAddressVo.setCacheTime(Integer.valueOf(Math.max(urlAddressVo.getCacheTime(), 1)));
        urlAddressVo.setSignExpireDate(Integer.valueOf(Math.max(urlAddressVo.getSignExpireDate(), 1)));
        urlAddressVo.setAccessTimesMax(Integer.valueOf(Math.max(urlAddressVo.getAccessTimesMax(), 1)));
        return urlAddressVo;
    }
}

