package com.biz.crm.business.common.auth.local.controller;

import com.biz.crm.business.common.auth.local.dto.TestSignDtoSign;
import com.biz.crm.business.common.auth.sdk.aop.SignBody;
import com.biz.crm.business.common.auth.sdk.aop.SignHeader;
import com.biz.crm.business.common.auth.sdk.service.AuthSignService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;
import java.util.Objects;

/**
 * 签名验证
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.12 20:54
 */
@Slf4j
@RestController
@RequestMapping("/v1/auth/authSign")
@Api(tags = "签名验证", hidden = true)
public class AuthSignController {

    @Autowired(required = false)
    private AuthSignService validateService;

    @ApiOperation(value = "参数排序验证")
    @PostMapping("/parameterBodySort")
    public Result parameterBodySort(@RequestBody Map<String, Object> parameterMap) {
        try {
            return Result.ok(this.validateService.parameterBodySort(parameterMap));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("参数排序错误，错误原因：" + e.getMessage());
        }
    }

    @ApiOperation(value = "参数签名")
    @PostMapping("/parameterBodySign")
    public Result parameterBodySign(@RequestBody Map<String, Object> parameterMap) {
        try {
            Object accessKeyObj = parameterMap.getOrDefault("accessKey", "");
            if (Objects.isNull(accessKeyObj)) {
                return Result.error("无accessKey信息!");
            }
            String accessKey = accessKeyObj.toString();
            Result result = new Result();
            parameterMap.remove("accessKey");
            UrlAddressVo urlAddressVo = this.validateService.getSignInfoForAccessKey(accessKey);
            parameterMap.put(accessKey, urlAddressVo.getAccessKey() + urlAddressVo.getSecretKey());
            String signToken = this.validateService.parameterBodySign(parameterMap);
            result.setResult(signToken);
            return result;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("参数签名错误，错误原因：" + e.getMessage());
        }
    }

    @ApiOperation(value = "Body签名类型:参数验证")
    @PostMapping("/bodySignVerify")
    @SignBody
    public Result bodySignVerify(@RequestBody TestSignDtoSign signDto) {
        try {
            return Result.ok("签名验证通过!");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("参数验证错误，错误原因：" + e.getMessage());
        }
    }

    @ApiOperation(value = "Header签名类型:参数验证")
    @PostMapping("/headerSignVerify")
    @SignHeader
    public Result headerSignVerify(@RequestBody TestSignDtoSign signDto) {
        try {
            return Result.ok("签名验证通过!");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("参数验证错误，错误原因：" + e.getMessage());
        }
    }

}
