package com.biz.crm.business.common.auth.local.controller;

import com.biz.crm.business.common.auth.sdk.service.UrlApiService;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 外部系统信息
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.15 12:54
 */
@Slf4j
@RestController
@RequestMapping("/v1/urlAddress/urlAddressVo")
@Api(tags = "外部系统信息", hidden = true)
public class UrlAddressVoController {

    @Autowired(required = false)
    private UrlApiService urlApiService;

    @ApiOperation(value = "根据账号获取详情")
    @GetMapping("/getUrlAddressByAccount")
    public Result getUrlAddressByAccount(@RequestParam(value = "account") String account) {
        try {
            return Result.ok(this.urlApiService.getUrlAddressByAccount(account));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("外部系统账号信息错误，错误原因：" + e.getMessage());
        }
    }

    @ApiOperation(value = "根据密匙获取详情")
    @GetMapping("/getUrlAddressByAccessKey")
    public Result getUrlAddressByAccessKey(@RequestParam(value = "accessKey") String accessKey) {
        try {
            return Result.ok(this.urlApiService.getUrlAddressByAccessKey(accessKey));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error("外部系统密匙信息错误，错误原因：" + e.getMessage());
        }
    }

}
