package com.biz.crm.business.common.auth.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * @describe 外部系统权限信息表信息
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.25 11:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_url_address_authority")
@ApiModel(value = "MdmUrlAddressAuthority", description = "外部系统权限信息表信息")
@Table(
        name = "mdm_url_address_authority",
        indexes = {
                @Index(name = "mdm_url_address_auth_idx1", unique = false, columnList = "user_name"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_url_address_authority", comment = "外部系统权限信息表信息")
public class UrlAddressAuthority extends TenantFlagOpEntity {


    private static final long serialVersionUID = 847227757500577391L;

    @ApiModelProperty("系统账号")
    @Column(name = "user_name", columnDefinition = "VARCHAR2(64)")
    private String userName;

    @ApiModelProperty("类型")
    @Column(name = "business_key", columnDefinition = "VARCHAR2(64)")
    private String businessKey;

    @ApiModelProperty("业务编码")
    @Column(name = "business_code", columnDefinition = "VARCHAR2(256)")
    private String businessCode;

    @ApiModelProperty("业务描述")
    @Column(name = "business_desc", columnDefinition = "VARCHAR2(256)")
    private String businessDesc;

}
