package com.biz.crm.business.common.auth.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.auth.local.entity.UrlAddressAuthority;
import com.biz.crm.business.common.auth.local.mapper.UrlAddressAuthorityMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;


/**
 * @describe 外部系统信息
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.25 11:42
 */
@Component
public class UrlAddressAuthorityRepository extends ServiceImpl<UrlAddressAuthorityMapper, UrlAddressAuthority> {

    public void delByUserName(String userName) {
        if (StringUtils.isEmpty(userName)) {
            return;
        }
        this.lambdaUpdate()
                .eq(UrlAddressAuthority::getUserName, userName)
                .remove();
    }

    public List<UrlAddressAuthority> getByUserName(String userName) {
        if (StringUtils.isEmpty(userName)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(UrlAddressAuthority::getUserName, userName)
                .list();
    }
}

