/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.aop;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.auth.sdk.constans.AuthConstant;
import com.biz.crm.business.common.auth.sdk.exception.SignException;
import com.biz.crm.business.common.auth.sdk.service.AuthSignService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.business.common.log.sdk.constant.ExternalLogGlobalConstants;
import com.biz.crm.business.common.log.sdk.dto.ExternalLogDetailDto;
import com.biz.crm.business.common.log.sdk.service.ExternalLogVoService;
import com.biz.crm.business.common.log.sdk.util.ExternalLogUtil;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SignHeaderAspect {
    private static final Logger log = LoggerFactory.getLogger(SignHeaderAspect.class);
    protected static final ThreadLocal<ConcurrentHashMap<Long, ExternalLogDetailDto>> LOG_VO_MAP = new ThreadLocal();
    @Autowired(required=false)
    private AuthSignService authSignService;
    @Autowired(required=false)
    private ExternalLogVoService externalLogVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Before(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignHeader) || @within(com.biz.crm.business.common.auth.sdk.aop.SignHeaderGlobal)")
    public void doBefore(JoinPoint joinPoint) {
        ExternalLogDetailDto detailDto = null;
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            Assert.notNull((Object)requestAttributes, (String)"\u8bf7\u6c42\u4e0d\u5408\u6cd5!");
            HttpServletRequest request = requestAttributes.getRequest();
            String requestMethod = request.getMethod();
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String paraName = (String)headerNames.nextElement();
                String paraValue = request.getHeader(paraName);
                headMap.put(paraName, paraValue);
            }
            HashMap<String, String> dataMap = new HashMap<String, String>(16);
            StringBuffer reqBody = new StringBuffer();
            if ("GET".equalsIgnoreCase(requestMethod)) {
                Enumeration enu = request.getParameterNames();
                while (enu.hasMoreElements()) {
                    String paraName = (String)enu.nextElement();
                    String paraValue = request.getParameter(paraName);
                    dataMap.put(paraName, paraValue);
                }
                reqBody.append(JSON.toJSONString(dataMap));
            } else {
                Optional.ofNullable(joinPoint.getArgs()).ifPresent(x -> {
                    if (((Object[])x).length > 1) {
                        reqBody.append(JSON.toJSONString((Object)x));
                    } else {
                        for (Object o : x) {
                            reqBody.append(JSON.toJSONString((Object)o));
                        }
                    }
                });
            }
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            String accessKey = request.getHeader("ak");
            detailDto = ExternalLogUtil.buildLogSaveInfo(dataMap);
            this.addLogVo(detailDto);
            detailDto.setReqHead(JSON.toJSONString(headMap));
            detailDto.setReqJson(reqBody.toString());
            detailDto.setAccessKey(accessKey);
            detailDto.setMethod(StringUtils.stripToEmpty((String)method.getName()));
            String requestUri = request.getRequestURI();
            detailDto.setRequestUri(requestUri);
            dataMap.put("REQUEST_URI_MAP_KEY", requestUri);
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            AtomicReference<String> methodMsg = new AtomicReference<String>("");
            Optional.ofNullable(apiOperation).filter(x -> !StringUtils.isEmpty((CharSequence)x.value())).ifPresent(x -> methodMsg.set(x.value()));
            detailDto.setMethodMsg(methodMsg.get());
            detailDto.setInvokeType(ExternalLogGlobalConstants.EXTERNAL_INTERFACE);
            this.addLogVo(detailDto);
            this.loginUserService.refreshAuthentication(null);
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, true);
            } else {
                log.info("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
            UrlAddressVo urlAddressVo = this.authSignService.getSignInfoForAccessKey(accessKey);
            detailDto.setUserName(urlAddressVo.getUserName());
            detailDto.setFullName(urlAddressVo.getFullName());
            this.addLogVo(detailDto);
            String secretKey = request.getHeader("sk");
            Assert.isTrue((boolean)StringUtils.isEmpty((CharSequence)secretKey), (String)"\u53c2\u6570[sk]\u4e0d\u5141\u8bb8\u4f20\u9012!");
            this.authSignService.valAuthority(urlAddressVo, dataMap);
            this.loginUserService.refreshAuthentication((Object)urlAddressVo);
            String timestamp = request.getHeader("timestamp");
            Assert.hasLength((String)timestamp, (String)"\u65f6\u95f4\u6233[timestamp]\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.hasLength((String)accessKey, (String)"\u53c2\u6570[ak]\u4e0d\u80fd\u4e3a\u7a7a!");
            String token = request.getHeader("token");
            Assert.hasLength((String)token, (String)"\u7b7e\u540d[token]\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isTrue((boolean)this.authSignService.verifySignExpired(urlAddressVo.getSignExpireDate(), timestamp), (String)("[" + SignException.SIGN_EXPIRED.getCode() + "]" + SignException.SIGN_EXPIRED.getDescription()));
            String parameterSign = this.authSignService.parameterHeaderSign(timestamp, accessKey, urlAddressVo.getSecretKey());
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)parameterSign, (CharSequence)token), (String)("[" + SignException.SIGN_ERROR.getCode() + "]" + SignException.SIGN_ERROR.getDescription()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (Objects.nonNull(detailDto)) {
                detailDto.setExceptionStack(ExceptionStackMsgUtil.stackMsg((Exception)e));
                detailDto.setTipMsg(e.getMessage());
                detailDto.setRespJson(JSON.toJSONString((Object)Result.error((String)e.getMessage())));
                if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                    this.externalLogVoService.addOrUpdateLog(detailDto, false);
                } else {
                    log.warn("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString(detailDto));
                }
            }
            throw e;
        }
    }

    @AfterReturning(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignHeader) || @within(com.biz.crm.business.common.auth.sdk.aop.SignHeaderGlobal)", returning="result")
    public void AfterReturning(Object result) {
        ExternalLogDetailDto detailDto = this.getLogVo();
        if (Objects.nonNull(detailDto)) {
            ExternalLogUtil.buildLogResult((ExternalLogDetailDto)detailDto, (Object)result);
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, false);
            } else {
                log.info("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
        }
    }

    @AfterThrowing(value="@annotation(com.biz.crm.business.common.auth.sdk.aop.SignHeader) || @within(com.biz.crm.business.common.auth.sdk.aop.SignHeaderGlobal)", throwing="e")
    public void AfterThrowing(Exception e) {
        ExternalLogDetailDto detailDto = this.getLogVo();
        if (Objects.nonNull(detailDto)) {
            detailDto.setExceptionStack(ExceptionStackMsgUtil.stackMsg((Exception)e));
            detailDto.setTipMsg(e.getMessage());
            detailDto.setRespJson(JSON.toJSONString((Object)Result.error((String)e.getMessage())));
            if (!AuthConstant.NOT_ES_LOG.contains(detailDto.getMethod())) {
                this.externalLogVoService.addOrUpdateLog(detailDto, false);
            } else {
                log.warn("\u5916\u90e8\u7cfb\u7edf\u65e5\u5fd7[{}]", (Object)JSON.toJSONString((Object)detailDto));
            }
        }
        log.error("======> AOP\u7b7e\u540d\u9a8c\u8bc1\u4fe1\u606f \u5f02\u5e38\u4fe1\u606f  <======");
        log.error(e.getMessage(), (Throwable)e);
    }

    private void addLogVo(ExternalLogDetailDto respVo) {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<Long, Object> logMap = LOG_VO_MAP.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        logMap.put(thread.getId(), respVo);
        LOG_VO_MAP.set(logMap);
    }

    private ExternalLogDetailDto getLogVo() {
        Thread thread = Thread.currentThread();
        ConcurrentHashMap<Long, Object> logMap = LOG_VO_MAP.get();
        if (logMap == null) {
            logMap = new ConcurrentHashMap(16);
        }
        ExternalLogDetailDto detailDto = logMap.get(thread.getId());
        logMap.remove(thread.getId());
        LOG_VO_MAP.set(logMap);
        return detailDto;
    }
}

