/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.local.entity.UrlAddressAuthority;
import com.biz.crm.business.common.auth.local.repository.UrlAddressAuthorityRepository;
import com.biz.crm.business.common.auth.local.repository.UrlAddressRepository;
import com.biz.crm.business.common.auth.local.service.UrlAddressService;
import com.biz.crm.business.common.auth.sdk.constans.AuthConstant;
import com.biz.crm.business.common.auth.sdk.dto.UrlAddressAuthorityDto;
import com.biz.crm.business.common.auth.sdk.eunm.BusinessKeyEnum;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressAuthorityVo;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class UrlAddressServiceImpl
implements UrlAddressService {
    private static final Logger log = LoggerFactory.getLogger(UrlAddressServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private UrlAddressRepository urlAddressRepository;
    @Autowired(required=false)
    private UrlAddressAuthorityRepository urlAddressAuthorityRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(UrlAddress dto) {
        UrlAddress urlAddress = this.valBaseInfo(dto);
        this.valSave(urlAddress);
        this.saveAuthorityList(dto.getInterfaceList(), dto.getUserName());
        this.urlAddressRepository.save((Object)urlAddress);
    }

    private void valSave(UrlAddress entity) {
        int countAccessKey = ((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getAccessKey, (Object)entity.getAccessKey())).count();
        Assert.isTrue((countAccessKey < 1 ? 1 : 0) != 0, (String)("ak[" + entity.getAccessKey() + "]\u5df2\u5b58\u5728"));
        int countUserName = ((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getUserName, (Object)entity.getUserName())).count();
        Assert.isTrue((countUserName < 1 ? 1 : 0) != 0, (String)("\u8d26\u53f7[" + entity.getUserName() + "]\u5df2\u5b58\u5728"));
    }

    private void saveAuthorityList(List<UrlAddressAuthorityDto> interfaceList, String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        this.urlAddressAuthorityRepository.delByUserName(userName);
        if (CollectionUtil.isEmpty(interfaceList)) {
            return;
        }
        ArrayList authorityList = Lists.newArrayList();
        String tenantCode = TenantUtils.getTenantCode();
        String delFlag = DelFlagStatusEnum.NORMAL.getCode();
        String enableCode = EnableStatusEnum.ENABLE.getCode();
        interfaceList.forEach(vo -> {
            UrlAddressAuthority addressAuthority = new UrlAddressAuthority();
            addressAuthority.setUserName(userName);
            String businessKey = vo.getBusinessKey();
            Assert.hasLength((String)businessKey, (String)("\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!" + BusinessKeyEnum.values()));
            BusinessKeyEnum businessKeyEnum = BusinessKeyEnum.codeToEnum((String)businessKey);
            Assert.notNull((Object)businessKeyEnum, (String)("\u6743\u9650\u7c7b\u578b[" + businessKey + "]\u4e0d\u5408\u6cd5!"));
            addressAuthority.setBusinessKey(businessKey);
            addressAuthority.setBusinessCode(vo.getBusinessCode());
            addressAuthority.setBusinessDesc(vo.getBusinessDesc());
            addressAuthority.setTenantCode(tenantCode);
            addressAuthority.setDelFlag(delFlag);
            addressAuthority.setEnableStatus(enableCode);
            authorityList.add(addressAuthority);
        });
        if (CollectionUtil.isNotEmpty((Collection)authorityList)) {
            this.urlAddressAuthorityRepository.saveBatch(authorityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(UrlAddress dto) {
        UrlAddress urlAddress = this.valBaseInfo(dto);
        this.valUpdate(urlAddress);
        this.saveAuthorityList(dto.getInterfaceList(), dto.getUserName());
        this.urlAddressRepository.updateById((Object)urlAddress);
    }

    private void valUpdate(UrlAddress entity) {
        entity.setModifyAccount(null);
        entity.setModifyName(null);
        entity.setModifyTime(null);
        Assert.hasLength((String)entity.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a!");
        UrlAddress oldEntity = (UrlAddress)((Object)this.urlAddressRepository.getById((Serializable)((Object)entity.getId())));
        Assert.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        int countAccessKey = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getAccessKey, (Object)entity.getAccessKey())).ne(UuidEntity::getId, (Object)entity.getId())).count();
        Assert.isTrue((countAccessKey < 1 ? 1 : 0) != 0, (String)("ak[" + entity.getAccessKey() + "]\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539!"));
        int countUserName = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.urlAddressRepository.lambdaQuery().eq(UrlAddress::getUserName, (Object)entity.getUserName())).ne(UuidEntity::getId, (Object)entity.getId())).count();
        Assert.isTrue((countUserName < 1 ? 1 : 0) != 0, (String)("\u8d26\u53f7[" + entity.getUserName() + "]\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539!"));
        this.urlAddressAuthorityRepository.delByUserName(oldEntity.getUserName());
        ArrayList delKeyList = Lists.newArrayList();
        delKeyList.add(this.getRedisKey(oldEntity.getAccessKey()));
        delKeyList.add(this.getRedisKey(oldEntity.getUserName()));
        this.redisService.del((List)delKeyList);
    }

    private UrlAddress valBaseInfo(UrlAddress dto) {
        String mobileUrl;
        Assert.notNull((Object)((Object)dto), (String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getUserName(), (String)"\u53c2\u6570[\u8d26\u53f7\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getUrl(), (String)"\u53c2\u6570[URL\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getAccessKey(), (String)"\u53c2\u6570[ak]\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)dto.getSecretKey(), (String)"\u53c2\u6570[sk]\u4e0d\u80fd\u4e3a\u7a7a!");
        String isAll = dto.getIsAll();
        Assert.hasLength((String)dto.getIsAll(), (String)"\u662f\u5426\u6240\u6709\u63a5\u53e3\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a!");
        String url = dto.getUrl();
        if (url.endsWith("/")) {
            dto.setUrl(url.substring(0, url.length() - 1));
        }
        if (StringUtils.isNotEmpty((CharSequence)(mobileUrl = dto.getMobileUrl())) && mobileUrl.endsWith("/")) {
            dto.setMobileUrl(mobileUrl.substring(0, url.length() - 1));
        }
        if (!BooleanEnum.TRUE.getCapital().equals(isAll) && !BooleanEnum.FALSE.getCapital().equals(isAll)) {
            throw new IllegalArgumentException("isAll\u4e0d\u5408\u6cd5,\u5fc5\u987b\u4e3a[Y/N]");
        }
        if (CollectionUtil.isNotEmpty(dto.getInterfaceList())) {
            dto.getInterfaceList().forEach(vo -> {
                BusinessKeyEnum businessKeyEnum = BusinessKeyEnum.codeToEnum((String)vo.getBusinessKey());
                Assert.notNull((Object)businessKeyEnum, (String)("\u6743\u9650\u7c7b\u578b[" + vo.getBusinessKey() + "]\u4e0d\u5408\u6cd5!"));
                switch (businessKeyEnum) {
                    case BUSINESS_INTERFACE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u6b64\u7c7b\u578b\u672a\u5b9a\u4e49!");
                    }
                }
            });
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (Objects.isNull(dto.getCacheTime())) {
            dto.setCacheTime(AuthConstant.DEFAULT_CACHE_TIME);
        }
        if (Objects.isNull(dto.getCacheRedisTime())) {
            dto.setCacheRedisTime(AuthConstant.DEFAULT_CACHE_TIME);
        }
        if (Objects.isNull(dto.getSignExpireDate())) {
            dto.setSignExpireDate(AuthConstant.DEFAULT_SIGN_EXPIRE_DATE);
        }
        if (Objects.isNull(dto.getAccessTimesMax())) {
            dto.setAccessTimesMax(AuthConstant.DEFAULT_ACCESS_TIMES_MAX);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateDelFlagByIds(ids);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List<UrlAddress> list = this.urlAddressRepository.findByIds(ids);
        Assert.notEmpty(list, (String)"\u9009\u62e9\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        this.urlAddressRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        ArrayList delKeyList = Lists.newArrayList();
        list.forEach(entity -> {
            delKeyList.add(this.getRedisKey(entity.getAccessKey()));
            delKeyList.add(this.getRedisKey(entity.getUserName()));
        });
        this.redisService.del((List)delKeyList);
    }

    @Override
    public UrlAddressVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        UrlAddress urlAddress = this.urlAddressRepository.findById(id);
        if (Objects.isNull((Object)urlAddress)) {
            return null;
        }
        UrlAddressVo urlAddressVo = (UrlAddressVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)urlAddress, UrlAddressVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<UrlAddressAuthority> urlAddressAuthorityList = this.urlAddressAuthorityRepository.getByUserName(urlAddressVo.getUserName());
        if (CollectionUtil.isEmpty(urlAddressAuthorityList)) {
            return urlAddressVo;
        }
        List authorityVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(urlAddressAuthorityList, UrlAddressAuthority.class, UrlAddressAuthorityVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<UrlAddressAuthorityVo>> authorityVoMap = authorityVoList.stream().collect(Collectors.groupingBy(UrlAddressAuthorityVo::getBusinessKey));
        Map authorityMap = urlAddressAuthorityList.stream().collect(Collectors.groupingBy(UrlAddressAuthority::getBusinessKey, Collectors.mapping(UrlAddressAuthority::getBusinessCode, Collectors.toList())));
        urlAddressVo.setAuthorityMap(authorityMap);
        urlAddressVo.setInterfaceList(authorityVoMap.getOrDefault(BusinessKeyEnum.BUSINESS_INTERFACE.getCode(), Lists.newArrayList()));
        return urlAddressVo;
    }

    @Override
    public String getRedisKey(String key) {
        Assert.hasLength((String)key, (String)"redis key must not null!");
        return "external:data_cache:" + key;
    }
}

