package com.biz.crm.business.common.auth.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.auth.sdk.dto.UrlAddressAuthorityDto;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.List;


/**
 * @describe 外部系统信息实体
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.25 11:42
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_url_address")
@ApiModel(value = "MdmUrlAddress", description = "外部系统信息表信息")
@Table(
        name = "mdm_url_address",
        indexes = {
                @Index(name = "mdm_url_address_index1", unique = true, columnList = "user_name"),
                @Index(name = "mdm_url_address_index2", unique = true, columnList = "access_key"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_url_address", comment = "外部系统信息表信息")
public class UrlAddress extends TenantFlagOpEntity {

    private static final long serialVersionUID = -7921400467743420964L;

    @ApiModelProperty("系统账号")
    @Column(name = "user_name", columnDefinition = "VARCHAR2(64)")
    @TableField(value = "user_name")
    private String userName;

    @ApiModelProperty("系统名称")
    @Column(name = "full_name", columnDefinition = "VARCHAR2(128)")
    @TableField(value = "full_name")
    private String fullName;

    @ApiModelProperty("url地址")
    @Column(name = "url", columnDefinition = "VARCHAR2(512)")
    @TableField(value = "url")
    private String url;

    @ApiModelProperty("移动端url地址")
    @Column(name = "mobile_url", columnDefinition = "VARCHAR2(512)")
    @TableField(value = "mobile_url")
    private String mobileUrl;

    @ApiModelProperty("账号ID")
    @Column(name = "access_id", columnDefinition = "VARCHAR2(256)")
    @TableField(value = "access_id")
    private String accessId;

    @ApiModelProperty("账号")
    @Column(name = "access_key", columnDefinition = "VARCHAR2(64)")
    @TableField(value = "access_key")
    private String accessKey;

    @ApiModelProperty("密匙")
    @Column(name = "secret_key", columnDefinition = "VARCHAR2(256)")
    @TableField(value = "secret_key")
    private String secretKey;

    @ApiModelProperty("环境")
    @Column(name = "environment", columnDefinition = "VARCHAR2(32)")
    @TableField(value = "environment")
    private String environment;

    @ApiModelProperty("业务标记")
    @Column(name = "business_key", columnDefinition = "VARCHAR2(64)")
    @TableField(value = "business_key")
    private String businessKey;

    @ApiModelProperty("系统缓存时间/分钟")
    @Column(name = "cache_time", columnDefinition = "INT")
    @TableField(value = "cache_time")
    private Integer cacheTime;

    @ApiModelProperty("Redis缓存时间/小时")
    @Column(name = "cache_redis_time", columnDefinition = "INT")
    private Integer cacheRedisTime;

    @ApiModelProperty("签名过期时间/分钟")
    @Column(name = "sign_expire_date", columnDefinition = "INT")
    @TableField(value = "sign_expire_date")
    private Integer signExpireDate;

    @ApiModelProperty("访问次数限制")
    @Column(name = "access_times_max", columnDefinition = "INT")
    @TableField(value = "access_times_max")
    private Integer accessTimesMax;

    @ApiModelProperty("token刷新key")
    @Column(name = "refresh_key", columnDefinition = "VARCHAR2(256)")
    @TableField(value = "refresh_key")
    private String refreshKey;

    @ApiModelProperty("配置租户编码")
    @Column(name = "actual_tenant_code", columnDefinition = "VARCHAR2(32)")
    @TableField(value = "actual_tenant_code")
    private String actualTenantCode;

    @ApiModelProperty("是否所有接口权限")
    @Column(name = "is_all", columnDefinition = "VARCHAR2(1) default 'Y'")
    @TableField(value = "is_all")
    private String isAll;

    @ApiModelProperty("接口类型权限")
    @Transient
    @TableField(exist = false)
    private List<UrlAddressAuthorityDto> interfaceList;
}
