package com.biz.crm.business.common.auth.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 外部系统信息
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2022.11.5 14:23
 */
@Component
public class UrlAddressDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_url_address_data_view";
    }

    @Override
    public String desc() {
        return "MDM 外部系统信息设置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT\n" +
                "\tt.id,\n" +
                "\tt.create_account,\n" +
                "\tt.create_name,\n" +
                "\tt.create_time,\n" +
                "\tt.modify_account,\n" +
                "\tt.modify_name,\n" +
                "\tt.modify_time,\n" +
                "\tt.del_flag,\n" +
                "\tt.enable_status,\n" +
                "\tt.remark,\n" +
                "\tt.tenant_code,\n" +
                "\tt.access_id,\n" +
                "\tt.access_key,\n" +
                "\tt.access_times_max,\n" +
                "\tt.actual_tenant_code,\n" +
                "\tt.cache_time,\n" +
                "\tt.full_name,\n" +
                "\tt.is_all,\n" +
                "\tt.mobile_url,\n" +
                "\tt.refresh_key,\n" +
                "\tt.secret_key,\n" +
                "\tt.sign_expire_date,\n" +
                "\tt.url,\n" +
                "\tt.user_name,\n" +
                "\tt.business_key,\n" +
                "\tt.environment,\n" +
                "\tt.cache_redis_time\n" +
                "FROM mdm_url_address t" +
                "  WHERE  t.del_flag ='" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}
