package com.biz.crm.business.common.auth.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.local.mapper.UrlAddressMapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;


/**
 * @describe 外部系统信息
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.25 11:42
 */
@Component
public class UrlAddressRepository extends ServiceImpl<UrlAddressMapper, UrlAddress> {


    /**
     * 根据账号获取详情
     *
     * @param account 账号
     * @return
     */
    public UrlAddress getUrlAddressByAccount(String account) {
        if (StringUtils.isEmpty(account)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(UrlAddress::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(UrlAddress::getUserName, account)
                .eq(UrlAddress::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .one();
    }

    /**
     * 根据密匙获取详情
     *
     * @param accessKey 密匙
     * @return
     */
    public UrlAddress getUrlAddressByAccessKey(String accessKey) {
        if (StringUtils.isEmpty(accessKey)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(UrlAddress::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(UrlAddress::getAccessKey, accessKey)
                .one();
    }

    /**
     * 根据ID获取详情
     *
     * @param id 主键
     * @return
     */
    public UrlAddress findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(UrlAddress::getTenantCode, TenantUtils.getTenantCode())
                .eq(UrlAddress::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(UrlAddress::getId, id)
                .one();
    }

    /**
     * 根据ID获取详情
     *
     * @param ids 主键
     * @return
     */
    public List<UrlAddress> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(UrlAddress::getTenantCode, TenantUtils.getTenantCode())
                .eq(UrlAddress::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(UrlAddress::getId, ids)
                .list();
    }

    /**
     * 根据id集合 更新启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        if (CollectionUtils.isEmpty(ids)
                || Objects.isNull(enable)) {
            return;
        }
        this.lambdaUpdate()
                .in(UrlAddress::getId, ids)
                .eq(UrlAddress::getTenantCode, TenantUtils.getTenantCode())
                .set(UrlAddress::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<UrlAddress> list = this.findByIds(ids);
        list.forEach(entity -> {
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            entity.setUserName(entity.getUserName() + "_" + entity.getId());
            entity.setAccessKey(entity.getAccessKey() + "_" + entity.getId());
        });
        this.updateBatchById(list);
    }
}

