package com.biz.crm.business.common.auth.local.controller;

import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.local.service.UrlAddressService;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.business.common.sdk.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 外部系统信息
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.15 12:54
 */
@Slf4j
@RestController
@RequestMapping("/v1/urlAddress/urlAddress")
@Api(tags = "外部系统信息", hidden = true)
public class UrlAddressController {

    @Autowired(required = false)
    private UrlAddressService urlAddressService;

    @ApiOperation(value = "新增", httpMethod = "POST")
    @PostMapping
    public Result<?> create(@RequestBody UrlAddress dto) {
        try {
            this.urlAddressService.save(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "更新", httpMethod = "PATCH")
    @PatchMapping
    public Result<?> update(@RequestBody UrlAddress dto) {
        try {
            this.urlAddressService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @PostMapping("/delete")
    public Result<?> delete(@RequestBody List<String> ids) {
        try {
            this.urlAddressService.deleteBatch(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.urlAddressService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.urlAddressService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "根据ID查询", httpMethod = "GET")
    @GetMapping("/findById")
    public Result<UrlAddressVo> findById(@RequestParam(value = "id") String id) {
        try {
            return Result.ok(this.urlAddressService.findById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
