package com.biz.crm.business.common.auth.local.service;


import com.biz.crm.business.common.auth.local.entity.UrlAddress;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;

import java.util.List;

/**
 * 获取 加密字符串
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.11.3 14:44
 */
public interface UrlAddressService {

    /**
     * 新增
     *
     * @param dto
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    void save(UrlAddress dto);

    /**
     * 编辑
     *
     * @param dto
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    void update(UrlAddress dto);

    /**
     * 删除
     *
     * @param ids
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    void disableBatch(List<String> ids);

    /**
     * 详情
     *
     * @param id
     * @return void
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.16 19:28
     */
    UrlAddressVo findById(String id);


    /**
     * 获取redis的key
     *
     * @param key
     * @return java.lang.String
     * @author huxmld
     * @version v1.0.0
     * @date 2024/5/9 16:54
     */
    String getRedisKey(String key);

}
