package com.biz.crm.business.common.auth.sdk.exception;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 签名异常定义
 *
 * @describe 签名
 * @author huxmld
 * @version v1.0.0
 * @date 2021/8/13 11:14
 */
@Getter
@AllArgsConstructor
public enum SignException {

    /**
     * 签名异常信息
     */
    NOT_NULL(20001, "参数不能为空!"),
    NO_PERMISSION(20002, "没有访问权限!"),
    SIGN_ERROR(20003, "签名未通过!"),
    SIGN_EXPIRED(20004, "签名已过期!"),
    ACCESS_LIMIT(20005, "访问次数限制!"),
    AK_DISABLE(20006, "账号已被禁用!"),
    ;
    private final Integer code;
    private final String description;
}
