package com.biz.crm.business.common.auth.sdk.constans;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 对外模块 全局常量
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.26 20:58
 */
public interface AuthConstant {

    /**
     * 外部系统信息统一数据字典前缀
     */
    String EXTERNAL_CACHE_REDIS = "external:data_cache:";

    /**
     * 系统访问限制
     */
    String EXTERNAL_ACCESS_LIMIT_LOCK = "external:access_limit_lock:";

    /**
     * 缓存默认时间 3分钟
     */
    Integer DEFAULT_CACHE_TIME = 3;
    /**
     * 单位时间访问常量
     */
    int MAX_SECONDS = 20;

    /**
     * 第三方签名默认过期时间 3分钟
     */
    Integer DEFAULT_SIGN_EXPIRE_DATE = 3;

    /**
     * 第三方访问次数默认限制  400
     */
    Integer DEFAULT_ACCESS_TIMES_MAX = 400;

    /**
     * 缓存时间
     */
    Integer CACHE_TIME = 3;

    /**
     * 不保存ES日志的方法
     */
    List<String> NOT_ES_LOG = Lists.newArrayList();

    /**
     * 接口权限
     */
    String REQUEST_URI_MAP_KEY = "REQUEST_URI_MAP_KEY";

    /**
     * url尾缀
     */
    String URL_TAIL = "/";


}
