package com.biz.crm.business.common.auth.sdk.eunm;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 外部系统权限信息 类型
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2024-01-19 02:55
 */
@Getter
@AllArgsConstructor
public enum BusinessKeyEnum {

    BUSINESS_INTERFACE("BUSINESS_INTERFACE", "接口"),
    ;
    private String code;

    private String desc;

    public static BusinessKeyEnum codeToEnum(String code) {
        for (BusinessKeyEnum v : values()) {
            if (v.code.equals(code)) {
                return v;
            }
        }
        return null;
    }

    public static BusinessKeyEnum descToEnum(String desc) {
        for (BusinessKeyEnum v : values()) {
            if (v.desc.equals(desc)) {
                return v;
            }
        }
        return null;
    }


    public static String getDesc(String code) {
        if (StringUtils.isEmpty(code)) {
            return StringUtils.EMPTY;
        }
        for (BusinessKeyEnum v : values()) {
            if (v.code.equals(code)) {
                return v.getDesc();
            }
        }
        return StringUtils.EMPTY;
    }

}
