package com.biz.crm.business.common.auth.sdk.service;


import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;

import java.util.Map;

/**
 * 签名验证 service
 *
 * @describe 简述
 * @author huxmld
 * @version v1.0.0
 * @date 2022.10.12 20:57
 */

public interface AuthSignService {

    /**
     * 根据ak获取账户信息
     *
     * @param accessKey
     * @return
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2021/8/16 11:29
     */
    UrlAddressVo getSignInfoForAccessKey(String accessKey);

    /**
     * 接口权限验证
     *
     * @param urlAddressVo
     * @param dataMap
     * @return boolean
     * @author huxmld
     * @version v1.0.0
     * @date 2024-01-19 03:41
     */
    void valAuthority(UrlAddressVo urlAddressVo,Map<String, Object> dataMap);

    /**
     * body参数排序
     *
     * @param parameterMap
     * @return java.lang.String
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022.10.12 20:57
     */
    String parameterBodySort(Map<String, Object> parameterMap);

    /**
     * body参数签名
     *
     * @param parameterMap
     * @return java.lang.String
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022.10.12 20:57
     */
    String parameterBodySign(Map<String, Object> parameterMap);

    /**
     * 验证签名是否过期
     *
     * @param signExpireDate 过期时间|单位分钟
     * @param timestamp      时间戳
     * @return java.lang.Boolean
     * @author huxmld
     * @version v1.0.0
     * @date 2023.1.5 13:08
     */
    Boolean verifySignExpired(Integer signExpireDate, String timestamp);

    /**
     * header参数 签名
     *
     * @param timestamp 时间戳
     * @param accessKey
     * @param secretKey
     * @return java.lang.String
     * @describe 简述
     * @author huxmld
     * @version v1.0.0
     * @date 2022.11.1 14:31
     */
    String parameterHeaderSign(String timestamp, String accessKey, String secretKey);
}
