package com.biz.crm.business.common.auth.sdk.strategy.security;

import com.biz.crm.business.common.auth.sdk.vo.AuthUserDetailVo;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 外部系统设置用户信息
 *
 * @author huxmld
 * @version v1.0.0
 * @date 2023.1.18 4:17
 */
@Slf4j
@Component
public class AuthAuthenticationRefreshStrategy implements AuthenticationRefreshStrategy {

    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    @Override
    public int getOrder() {
        return 29;
    }

    @Override
    public boolean matched(Object info) {
        if (Objects.isNull(info)) {
            return false;
        }
        // 只有在AuthUserDetailVo对象存在的情况下，创建操作者
        return info instanceof UrlAddressVo;
    }

    @Override
    public UserIdentity refresh(Object info) {
        try {
            UrlAddressVo urlAddressVo = (UrlAddressVo) info;
            AuthUserDetailVo userIdentity = new AuthUserDetailVo();
            userIdentity.setUsername(urlAddressVo.getUserName());
            userIdentity.setRealName(urlAddressVo.getFullName());
            userIdentity.setAccount(urlAddressVo.getUserName());
            userIdentity.setAccessId(urlAddressVo.getAccessId());
            userIdentity.setAccessKey(urlAddressVo.getAccessKey());
            // 厂商用户
            userIdentity.setIdentityType("u");
            String[] roleCodes = this.simpleSecurityProperties.getIndependencyRoles();
            userIdentity.setRoleCodes(roleCodes);
            //若配置了租户编码，则将配置的租户编码设置进来
            if (StringUtils.isNotEmpty(urlAddressVo.getActualTenantCode())) {
                userIdentity.setTenantCode(urlAddressVo.getActualTenantCode());
            } else {
                userIdentity.setTenantCode(TenantUtils.getTenantCode());
            }
            // 生成 User
            return userIdentity;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw e;
        }
    }

}
