/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.auth.sdk.strategy.security;

import com.biz.crm.business.common.auth.sdk.vo.AuthUserDetailVo;
import com.biz.crm.business.common.auth.sdk.vo.UrlAddressVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthAuthenticationRefreshStrategy
implements AuthenticationRefreshStrategy {
    private static final Logger log = LoggerFactory.getLogger(AuthAuthenticationRefreshStrategy.class);
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public int getOrder() {
        return 29;
    }

    public boolean matched(Object info) {
        if (Objects.isNull(info)) {
            return false;
        }
        return info instanceof UrlAddressVo;
    }

    public UserIdentity refresh(Object info) {
        try {
            UrlAddressVo urlAddressVo = (UrlAddressVo)((Object)info);
            AuthUserDetailVo userIdentity = new AuthUserDetailVo();
            userIdentity.setUsername(urlAddressVo.getUserName());
            userIdentity.setRealName(urlAddressVo.getFullName());
            userIdentity.setAccount(urlAddressVo.getUserName());
            userIdentity.setAccessId(urlAddressVo.getAccessId());
            userIdentity.setAccessKey(urlAddressVo.getAccessKey());
            userIdentity.setIdentityType("u");
            String[] roleCodes = this.simpleSecurityProperties.getIndependencyRoles();
            userIdentity.setRoleCodes(roleCodes);
            if (StringUtils.isNotEmpty((CharSequence)urlAddressVo.getActualTenantCode())) {
                userIdentity.setTenantCode(urlAddressVo.getActualTenantCode());
            } else {
                userIdentity.setTenantCode(TenantUtils.getTenantCode());
            }
            return userIdentity;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

